/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.importers.lsf;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.swing.JFileChooser;
import pt.lsts.imc.gz.MultiMemberGZIPInputStream;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.util.FileUtil;

public class ConcatenateLsfLog {
    public static File[] chooseFolders(Component parent, String initialDir) {
        JFileChooser chooser = new JFileChooser(initialDir);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(I18n.text("Select folders  to concatenate"));
        chooser.setFileSelectionMode(1);
        int option = chooser.showOpenDialog(parent);
        if (option == 0) {
            return chooser.getSelectedFiles();
        }
        return null;
    }

    public static void concatenateFolders(File[] folders, File destination, LinkedHashMap<String, Object> options) throws Exception {
        destination.mkdirs();
        Arrays.sort(folders);
        File fxIMCGZ = new File(folders[0], "IMC.xml.gz");
        if (fxIMCGZ.exists()) {
            NeptusLog.pub().info((Object)("Copying " + fxIMCGZ.getAbsolutePath()));
            FileUtil.copyFile(fxIMCGZ.getAbsolutePath(), new File(destination, "IMC.xml.gz").getAbsolutePath());
        } else {
            File fxIMC = new File(folders[0], "IMC.xml");
            if (fxIMC.exists()) {
                NeptusLog.pub().info((Object)("Copying %filename" + fxIMC.getAbsolutePath()));
                FileUtil.copyFile(fxIMC.getAbsolutePath(), new File(destination, "IMC.xml").getAbsolutePath());
            } else {
                NeptusLog.pub().info((Object)"Missing IMC.xml");
            }
        }
        File fxConfig = new File(folders[0], "Config.ini");
        if (fxIMCGZ.exists()) {
            NeptusLog.pub().info((Object)("Copying " + fxConfig.getAbsolutePath()));
            FileUtil.copyFile(fxConfig.getAbsolutePath(), new File(destination, "Config.ini").getAbsolutePath());
        } else {
            NeptusLog.pub().info((Object)("Missing " + fxConfig.getAbsolutePath()));
        }
        for (File folder : folders) {
            File src = new File(folder, "Data.lsf");
            if (src.canRead()) {
                FileUtil.appendToFile(new File(destination, "Data.lsf"), new File(folder, "Data.lsf"));
                NeptusLog.pub().info((Object)("<###> " + I18n.textf("Concatenating %filename", new File(folder, "Data.lsf").getAbsolutePath())));
                continue;
            }
            src = new File(folder, "Data.lsf.gz");
            if (src.canRead()) {
                FileUtil.appendToFile(new File(destination, "Data.lsf"), (InputStream)new MultiMemberGZIPInputStream((InputStream)new FileInputStream(new File(folder, "Data.lsf.gz"))));
                NeptusLog.pub().info((Object)("<###> " + I18n.textf("Concatenating %filename", new File(folder, "Data.lsf.gz").getAbsolutePath())));
                continue;
            }
            NeptusLog.pub().info((Object)"Missing Data.lsf");
        }
    }

    public static void main(String[] args) throws Exception {
        File[] folders = ConcatenateLsfLog.chooseFolders(null, new File(".").getAbsolutePath());
        ConcatenateLsfLog.concatenateFolders(folders, new File("/home/zp/Desktop/output"), null);
    }
}

