/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.importers.lsf;

import java.util.Vector;
import javax.swing.JFileChooser;
import javax.vecmath.Point3d;
import pt.lsts.imc.DeviceState;
import pt.lsts.imc.Distance;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.BathymetryInfo;
import pt.lsts.neptus.mra.api.BathymetryParser;
import pt.lsts.neptus.mra.api.BathymetryPoint;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.renderer3d.Util3D;
import pt.lsts.neptus.types.coord.LocationType;

public class DVLBathymetryParser
implements BathymetryParser {
    private LsfIndex idx;
    private long first;
    private long last;
    private BathymetryInfo info;
    private Vector<Integer> beamIds = new Vector();
    int curIdx = 0;

    public DVLBathymetryParser(IMraLogGroup source) {
        this.idx = source.getLsfIndex();
        this.initialize();
    }

    public DVLBathymetryParser(LsfIndex index) {
        this.idx = index;
        this.initialize();
    }

    @Override
    public long getFirstTimestamp() {
        return this.first;
    }

    @Override
    public long getLastTimestamp() {
        return this.last;
    }

    @Override
    public synchronized BathymetryInfo getBathymetryInfo() {
        if (this.info.totalNumberOfPoints == -1) {
            // empty if block
        }
        return this.info;
    }

    private synchronized void initialize() {
        IMCMessage fstm = this.idx.getMessage(this.idx.getFirstMessageOfType("Distance"));
        IMCMessage lstm = this.idx.getMessage(this.idx.getLastMessageOfType("Distance"));
        this.beamIds.add(this.idx.getEntityId("DVL Beam 0"));
        this.beamIds.add(this.idx.getEntityId("DVL Beam 1"));
        this.beamIds.add(this.idx.getEntityId("DVL Beam 2"));
        this.beamIds.add(this.idx.getEntityId("DVL Beam 3"));
        if (fstm != null) {
            this.first = fstm.getTimestampMillis();
        }
        if (lstm != null) {
            this.last = lstm.getTimestampMillis();
        }
        this.info = new BathymetryInfo();
        double minLat = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double minLon = Double.MAX_VALUE;
        double maxLon = -1.7976931348623157E308;
        double maxAlt = 0.0;
        double maxDepth = 0.0;
        for (EstimatedState s : this.idx.getIterator(EstimatedState.class, 1000)) {
            LocationType loc = IMCUtils.parseLocation((IMCMessage)s).convertToAbsoluteLatLonDepth();
            minLat = Math.min(minLat, loc.getLatitudeDegs());
            minLon = Math.min(minLon, loc.getLongitudeDegs());
            maxLat = Math.max(maxLat, loc.getLatitudeDegs());
            maxLon = Math.max(maxLon, loc.getLongitudeDegs());
            maxAlt = Math.max(maxAlt, s.getAlt());
            maxDepth = Math.max(maxDepth, s.getDepth());
        }
        if (maxAlt > 110.0) {
            maxAlt = 50.0;
        }
        double margin = Math.cos(Math.toRadians(22.5)) * maxAlt;
        LocationType topLeft = new LocationType(maxLat, minLon);
        LocationType bottomRight = new LocationType(minLat, maxLon);
        topLeft.translatePosition(margin, -margin, 0.0);
        bottomRight.translatePosition(-margin, margin, 0.0);
        this.info.topLeft = topLeft.convertToAbsoluteLatLonDepth();
        this.info.bottomRight = bottomRight.convertToAbsoluteLatLonDepth();
        this.info.maxDepth = (float)maxDepth;
        for (Distance d : this.idx.getIterator(Distance.class)) {
            if (!this.beamIds.contains(d.getSrcEnt())) continue;
            ++this.info.totalNumberOfPoints;
        }
    }

    @Override
    public BathymetrySwath getSwathAt(long timestamp) {
        int cur = this.curIdx;
        this.curIdx = this.idx.advanceToTime(0, (double)timestamp / 1000.0);
        if (this.curIdx == -1) {
            this.curIdx = cur;
            return null;
        }
        return this.nextSwath();
    }

    @Override
    public BathymetrySwath nextSwath() {
        return this.nextSwath(1.0);
    }

    @Override
    public BathymetrySwath nextSwath(double prob) {
        int[] msgs = new int[4];
        double[] distances = new double[4];
        double[] angles = new double[4];
        DeviceState devState = null;
        int count = 0;
        while (count < 4 && this.curIdx != -1 && this.curIdx < this.idx.getNumberOfMessages()) {
            this.curIdx = this.idx.getNextMessageOfType(262, this.curIdx);
            int eid = this.idx.entityOf(this.curIdx);
            int bid = this.beamIds.indexOf(eid);
            if (bid == -1 || msgs[bid] != 0) continue;
            msgs[bid] = this.curIdx;
            ++count;
            try {
                if (devState != null) continue;
                devState = (DeviceState)((Distance)this.idx.getMessage(this.curIdx, Distance.class)).getLocation().firstElement();
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
        if (count < 4) {
            return null;
        }
        try {
            for (int i = 0; i < 4; ++i) {
                Distance d = (Distance)this.idx.getMessage(msgs[i], Distance.class);
                distances[i] = d.getValue();
                angles[i] = Math.PI + 1.5707963267948966 * (double)i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        IMCMessage state = this.idx.getMessageAtOrAfter("EstimatedState", msgs[0], this.idx.timeOf(msgs[0]));
        if (state == null) {
            return null;
        }
        BathymetryPoint[] data = new BathymetryPoint[4];
        SystemPositionAndAttitude pose = IMCUtils.parseState(state);
        for (int i = 0; i < 4; ++i) {
            float[] offsets = DVLBathymetryParser.getOffsets(distances[i], angles[i], pose);
            data[i] = new BathymetryPoint(offsets[0], offsets[1], offsets[2]);
        }
        return new BathymetrySwath(state.getTimestampMillis(), IMCUtils.parseState(state), data);
    }

    @Override
    public void rewind() {
        this.curIdx = 0;
    }

    @Override
    public boolean getHasIntensity() {
        return false;
    }

    static float[] getOffsets(double range, double angle, SystemPositionAndAttitude pose) {
        Point3d pt0 = new Point3d(Math.cos(22.0) * range, 0.0, range);
        if (angle != 0.0) {
            pt0 = Util3D.setTransform(pt0, 0.0, 0.0, angle);
        }
        pt0 = Util3D.setTransform(pt0, pose.getRoll(), pose.getPitch(), pose.getYaw() + 1.5707963267948966);
        return new float[]{(float)pt0.x, (float)pt0.y, (float)(pt0.z + pose.getPosition().getDepth())};
    }

    public static void main(String[] args) throws Exception {
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(null);
        LsfIndex idx = new LsfIndex(chooser.getSelectedFile());
        DVLBathymetryParser parser = new DVLBathymetryParser(idx);
        BathymetrySwath swath = parser.nextSwath();
        while (swath != null) {
            for (BathymetryPoint bp : swath.getData()) {
                System.out.println(bp.north + ", " + bp.east + ", " + bp.depth);
            }
            swath = parser.nextSwath();
            System.out.println();
        }
    }
}

