/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.importers.lsf;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.IMCMessageType;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.mra.importers.IMraLog;

public class LsfMraLog
implements IMraLog {
    LsfIndex index;
    String name;
    int curIndex = -1;
    int type;
    private int numberOfEntries = -1;

    public LsfMraLog(LsfIndex index, String name) {
        this.index = index;
        this.name = name;
        this.type = index.getDefinitions().getMessageId(name);
        this.curIndex = index.getFirstMessageOfType(this.type);
    }

    protected void advanceUntil(long timestamp) {
        while (this.curIndex != -1 && this.currentTimeMillis() < timestamp) {
            this.curIndex = this.index.getNextMessageOfType(this.name, this.curIndex);
        }
    }

    @Override
    public IMCMessage getEntryAtOrAfter(long timestamp) {
        if (this.curIndex == -1) {
            return null;
        }
        if ((double)(timestamp / 1000L) > this.index.timeOf(this.index.getLastMessageOfType(this.type))) {
            return null;
        }
        this.advanceUntil(timestamp);
        if (this.curIndex != -1) {
            return this.index.getMessage(this.curIndex);
        }
        return null;
    }

    @Override
    public IMCMessage getEntryAtOrAfter(long timestamp, String entityName) {
        if (this.curIndex == -1) {
            return null;
        }
        if ((double)(timestamp / 1000L) > this.index.timeOf(this.index.getLastMessageOfType(this.type))) {
            return null;
        }
        this.advanceUntil(timestamp);
        if (this.curIndex != -1) {
            IMCMessage msg = this.index.getMessage(this.curIndex);
            while (msg != null) {
                if (this.index.getEntityName(msg.getHeader().getInteger("src_ent")).equals(entityName)) {
                    return msg;
                }
                msg = this.nextLogEntry();
            }
        }
        return null;
    }

    public IMCMessage getEntryAtOrAfter(long timestamp, int source) {
        if (this.curIndex == -1) {
            return null;
        }
        if ((double)(timestamp / 1000L) > this.index.timeOf(this.index.getLastMessageOfType(this.type))) {
            return null;
        }
        this.advanceUntil(timestamp);
        if (this.curIndex != -1) {
            IMCMessage msg = this.index.getMessage(this.curIndex);
            while (msg != null) {
                if (msg.getSrc() == source) {
                    return msg;
                }
                msg = this.nextLogEntry();
            }
        }
        return null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public IMCMessage getLastEntry() {
        this.curIndex = this.index.getLastMessageOfType(this.index.getDefinitions().getMessageId(this.name));
        if (this.curIndex == -1) {
            return null;
        }
        return this.index.getMessage(this.curIndex);
    }

    @Override
    public IMCMessageType format() {
        return this.index.getMessage(this.index.getFirstMessageOfType(this.name)).getMessageType();
    }

    @Override
    public LinkedHashMap<String, Object> metaInfo() {
        return new LinkedHashMap<String, Object>();
    }

    @Override
    public long currentTimeMillis() {
        if (this.curIndex == -1) {
            return (long)(this.index.timeOf(this.index.getLastMessageOfType(this.name)) * 1000.0);
        }
        return (long)(this.index.timeOf(this.curIndex) * 1000.0);
    }

    @Override
    public IMCMessage nextLogEntry() {
        this.curIndex = this.index.getNextMessageOfType(this.name, this.curIndex);
        if (this.curIndex == -1) {
            return null;
        }
        return this.index.getMessage(this.curIndex);
    }

    @Override
    public IMCMessage firstLogEntry() {
        this.curIndex = this.index.getFirstMessageOfType(this.name);
        return this.index.getMessage(this.curIndex);
    }

    @Override
    public void advance(long millis) {
        if (this.curIndex == -1) {
            return;
        }
        double before = this.currentTimeMillis();
        this.advanceUntil(this.currentTimeMillis() + millis);
        if (this.curIndex != -1 && (double)this.currentTimeMillis() <= before) {
            this.curIndex = this.index.getNextMessageOfType(this.name, this.curIndex + 1);
        }
    }

    @Override
    public IMCMessage getCurrentEntry() {
        if (this.curIndex == -1) {
            return null;
        }
        return this.index.getMessage(this.curIndex);
    }

    @Override
    public Collection<IMCMessage> getExactTimeEntries(long timeStampMillis) {
        this.advanceUntil(timeStampMillis);
        Vector<IMCMessage> messages = new Vector<IMCMessage>();
        while (this.currentTimeMillis() == timeStampMillis) {
            messages.add(this.getCurrentEntry());
        }
        return messages;
    }

    @Override
    public int getNumberOfEntries() {
        if (this.numberOfEntries == -1) {
            int count = 0;
            int type = this.index.getDefinitions().getMessageId(this.name);
            int i = this.index.getFirstMessageOfType(type);
            while (i != -1) {
                ++count;
                i = this.index.getNextMessageOfType(type, i);
            }
            this.numberOfEntries = count;
        }
        return this.numberOfEntries;
    }

    public static void main(String[] args) throws Exception {
        LsfIndex index = new LsfIndex(new File("/home/jqcorreia/Desktop/merge2/Data.lsf"), new IMCDefinition((InputStream)new FileInputStream(new File("/home/jqcorreia/Desktop/merge2/IMC.xml"))));
        LsfMraLog log = new LsfMraLog(index, "EstimatedState");
        NeptusLog.pub().info((Object)("<###> " + index.getMessage(0).getTimestamp()));
        NeptusLog.pub().info((Object)("<###> " + log.getCurrentEntry().getTimestamp()));
        NeptusLog.pub().info((Object)("<###> " + index.getMessage(1).getTimestamp()));
        NeptusLog.pub().info((Object)("<###> " + index.getMessage(2).getTimestamp()));
        NeptusLog.pub().info((Object)("<###> " + index.getMessage(0).getTimestamp()));
        for (int i = 0; i < 200; ++i) {
            IMCMessage m = index.getMessage(i);
            NeptusLog.pub().info((Object)("<###> " + m.getAbbrev() + " " + m.getTimestamp()));
        }
    }
}

