/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRACombinedPlot;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(name="CTD chart", active=false)
public class CtdPlot
extends MRACombinedPlot {
    public CtdPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"Conductivity"});
    }

    @Override
    public String getName() {
        return I18n.text("CTD");
    }

    @Override
    public void process(LsfIndex source) {
        short rightEntity = source.getMessage(source.getFirstMessageOfType("Conductivity")).getSrcEnt();
        for (IMCMessage c : source.getIterator("Conductivity")) {
            this.addValue(c.getTimestampMillis(), "Conductivity." + c.getSourceName(), c.getDouble("value"));
        }
        for (IMCMessage c : source.getIterator("Temperature")) {
            if (c.getSrcEnt() != rightEntity) continue;
            this.addValue(c.getTimestampMillis(), "Temperature." + c.getSourceName(), c.getDouble("value"));
        }
        for (IMCMessage c : source.getIterator("Pressure")) {
            if (c.getSrcEnt() != rightEntity) continue;
            this.addValue(c.getTimestampMillis(), "Pressure." + c.getSourceName(), c.getDouble("value"));
        }
    }
}

