/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.plots.MRA2DPlot;
import pt.lsts.neptus.mra.plots.TimedXYDataItem;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(active=false)
public class EstimatedStatePlot
extends MRA2DPlot
implements LogMarkerListener {
    public EstimatedStatePlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"EstimatedState"});
    }

    @Override
    public void process(LsfIndex source) {
        for (IMCMessage state : source.getIterator("EstimatedState", 0, (long)(this.timestep * 1000.0))) {
            LocationType loc = new LocationType();
            loc.setLatitudeRads(state.getDouble("lat"));
            loc.setLongitudeRads(state.getDouble("lon"));
            loc.translatePosition(state.getDouble("x"), state.getDouble("y"), state.getDouble("z"));
            loc.convertToAbsoluteLatLonDepth();
            this.addValue(state.getTimestampMillis(), loc.getLatitudeDegs(), loc.getLongitudeDegs(), state.getSourceName(), "position");
        }
        IMCMessage estate = source.getMessage(source.getFirstMessageOfType("EstimatedState"));
        LocationType ref = new LocationType(Math.toDegrees(estate.getDouble("lat")), Math.toDegrees(estate.getDouble("lon")));
        for (IMCMessage state : source.getIterator("SimulatedState", 0, (long)(this.timestep * 1000.0))) {
            LocationType loc = new LocationType();
            if (state.getTypeOf("lat") != null) {
                loc.setLatitudeRads(state.getDouble("lat"));
                loc.setLongitudeRads(state.getDouble("lon"));
            } else {
                loc.setLocation(ref);
            }
            loc.translatePosition(state.getDouble("x"), state.getDouble("y"), state.getDouble("z"));
            loc.convertToAbsoluteLatLonDepth();
            this.addValue(state.getTimestampMillis(), loc.getLatitudeDegs(), loc.getLongitudeDegs(), state.getSourceName(), "simulator");
        }
    }

    @Override
    public String getName() {
        return I18n.text("Position");
    }

    @Override
    public String getXAxisName() {
        return "Latitude";
    }

    @Override
    public String getYAxisName() {
        return "Longitude";
    }

    @Override
    public void addLogMarker(LogMarker marker) {
        XYSeries markerSeries = this.getMarkerSeries();
        IMCMessage state = this.mraPanel.getSource().getLog("EstimatedState").getEntryAtOrAfter(new Double(marker.getTimestamp()).longValue());
        LocationType loc = new LocationType();
        loc.setLatitudeRads(state.getDouble("lat"));
        loc.setLongitudeRads(state.getDouble("lon"));
        loc.translatePosition(state.getDouble("x"), state.getDouble("y"), state.getDouble("z"));
        loc.convertToAbsoluteLatLonDepth();
        if (markerSeries != null) {
            markerSeries.add((XYDataItem)new TimedXYDataItem(loc.getLatitudeDegs(), loc.getLongitudeDegs(), new Double(marker.getTimestamp()).longValue(), marker.getLabel()));
        }
    }

    @Override
    public void removeLogMarker(LogMarker marker) {
    }

    @Override
    public void GotoMarker(LogMarker marker) {
    }
}

