/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRACombinedPlot;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription
public class EulerAnglesPlot
extends MRACombinedPlot {
    public EulerAnglesPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public String getName() {
        return I18n.text("Euler Angles");
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"EstimatedState"});
    }

    @Override
    public void process(LsfIndex source) {
        if (source.getDefinitions().getVersion().compareTo("5.0.0") >= 0) {
            for (IMCMessage msg : source.getIterator("EstimatedState", 0, (long)(this.timestep * 1000.0))) {
                this.addValue(msg.getTimestampMillis(), I18n.text("Phi (deg).") + msg.getSourceName(), Math.toDegrees(msg.getDouble("phi")));
                this.addValue(msg.getTimestampMillis(), I18n.text("Theta (deg).") + msg.getSourceName(), Math.toDegrees(msg.getDouble("theta")));
                this.addValue(msg.getTimestampMillis(), I18n.text("Psi (deg).") + msg.getSourceName(), Math.toDegrees(msg.getDouble("psi")));
            }
        } else {
            for (IMCMessage msg : source.getIterator("EulerAngles", 0, (long)(this.timestep * 1000.0))) {
                this.addValue(msg.getTimestampMillis(), I18n.text("Phi (deg).") + msg.getSourceName(), Math.toDegrees(msg.getDouble("roll")));
                this.addValue(msg.getTimestampMillis(), I18n.text("Theta (deg).") + msg.getSourceName(), Math.toDegrees(msg.getDouble("pitch")));
                this.addValue(msg.getTimestampMillis(), I18n.text("Psi (deg).") + msg.getSourceName(), Math.toDegrees(msg.getDouble("yaw")));
            }
        }
    }
}

