/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.util.Arrays;
import java.util.Vector;
import javax.swing.ImageIcon;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;
import pt.lsts.neptus.util.ImageUtils;

public class GenericPlot
extends MRATimeSeriesPlot {
    protected String[] fieldsToPlot = null;

    public GenericPlot(String[] fieldsToPlot, MRAPanel panel) {
        super(panel);
        this.fieldsToPlot = fieldsToPlot;
    }

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("images/menus/graph2.png");
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    @Override
    public String getName() {
        return Arrays.toString(this.fieldsToPlot);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        for (String field : this.fieldsToPlot) {
            String messageName = field.split("\\.")[0];
            if (index.containsMessagesOfType(new String[]{messageName})) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector<String> getForbiddenSeries() {
        return this.forbiddenSeries;
    }

    @Override
    public void process(LsfIndex source) {
        for (String field : this.fieldsToPlot) {
            String messageName = field.split("\\.")[0];
            String variable = field.split("\\.")[1];
            for (IMCMessage m : source.getIterator(messageName, 0, (long)(this.timestep * 1000.0))) {
                String seriesName = "";
                seriesName = m.getValue("id") != null ? m.getSourceName() + "." + source.getEntityName(m.getSrc(), (int)m.getSrcEnt()) + "." + field + "." + m.getValue("id") : m.getSourceName() + "." + source.getEntityName(m.getSrc(), (int)m.getSrcEnt()) + "." + field;
                if (m.getMessageType().getFieldUnits(variable) != null && m.getMessageType().getFieldUnits(variable).startsWith("rad")) {
                    this.addValue(m.getTimestampMillis(), seriesName, Math.toDegrees(m.getDouble(variable)));
                    continue;
                }
                this.addValue(m.getTimestampMillis(), seriesName, m.getDouble(variable));
            }
        }
    }
}

