/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.LblBeacon;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.types.LblConfigAdapter;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription
public class LblRangesPlot
extends MRATimeSeriesPlot {
    protected LinkedHashMap<Integer, Color> beaconColors = new LinkedHashMap();
    protected LinkedHashMap<Integer, Shape> beaconShapes = new LinkedHashMap();
    protected Vector<Color> acceptedColors = new Vector();
    protected Vector<Color> rejectedColors = new Vector();
    protected Vector<Shape> possibleShapes = new Vector();

    public LblRangesPlot(MRAPanel panel) {
        super(panel);
        this.acceptedColors.add(Color.blue);
        this.acceptedColors.add(Color.green.darker());
        this.acceptedColors.add(Color.cyan);
        this.acceptedColors.add(new Color(128, 0, 255));
        this.rejectedColors.add(Color.red);
        this.rejectedColors.add(new Color(255, 160, 0));
        this.rejectedColors.add(Color.magenta);
        this.rejectedColors.add(Color.black);
        this.possibleShapes.add(new Ellipse2D.Double(0.0, 0.0, 5.0, 5.0));
        this.possibleShapes.add(new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0));
        GeneralPath gp = new GeneralPath();
        gp.moveTo(0.0, 2.5);
        gp.lineTo(2.5, -2.5);
        gp.lineTo(-2.5, -2.5);
        gp.closePath();
        this.possibleShapes.add(gp);
        gp = new GeneralPath();
        gp.moveTo(0.0, 2.5);
        gp.lineTo(2.5, 0.0);
        gp.lineTo(0.0, -2.5);
        gp.lineTo(-2.5, 0.0);
        gp.closePath();
        this.possibleShapes.add(gp);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"LblRangeAcceptance"});
    }

    @Override
    public String getName() {
        return I18n.text("LBL ranges");
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    @Override
    public void process(LsfIndex source) {
        IMCMessage config = source.getMessage(source.getLastMessageOfType("LblConfig"));
        LinkedHashMap<Integer, String> beaconNames = new LinkedHashMap<Integer, String>();
        LblConfigAdapter adapter = new LblConfigAdapter();
        adapter.setData(config);
        int i = 0;
        for (LblBeacon b : adapter.getBeacons()) {
            if (!this.acceptedColors.isEmpty()) {
                this.beaconColors.put(i * 2, this.acceptedColors.remove(0));
                this.beaconColors.put(i * 2 + 1, this.rejectedColors.remove(0));
                this.beaconShapes.put(i * 2, this.possibleShapes.get(0));
                this.beaconShapes.put(i * 2 + 1, this.possibleShapes.remove(0));
            }
            beaconNames.put(i++, b.getBeacon());
            this.addTrace(I18n.text("Accepted.") + b.getBeacon());
            this.addTrace(I18n.text("Rejected.") + b.getBeacon());
        }
        for (IMCMessage msg : source.getIterator("LblRangeAcceptance")) {
            String beaconName = msg.getString("id");
            if (beaconNames.containsKey(msg.getInteger("id"))) {
                beaconName = (String)beaconNames.get(msg.getInteger("id"));
            }
            if (msg.getString("acceptance").equals("ACCEPTED")) {
                this.addValue(msg.getTimestampMillis(), I18n.text("Accepted.") + beaconName, msg.getDouble("range"));
                continue;
            }
            this.addValue(msg.getTimestampMillis(), I18n.text("Rejected.") + beaconName, msg.getDouble("range"));
        }
    }

    @Override
    public JFreeChart createChart() {
        JFreeChart chart = super.createChart();
        ((XYLineAndShapeRenderer)chart.getXYPlot().getRenderer()).setShapesVisible(true);
        ((XYLineAndShapeRenderer)chart.getXYPlot().getRenderer()).setLinesVisible(false);
        for (int i : this.beaconColors.keySet()) {
            ((XYLineAndShapeRenderer)chart.getXYPlot().getRenderer()).setSeriesPaint(i, (Paint)this.beaconColors.get(i));
        }
        for (int i : this.beaconShapes.keySet()) {
            ((XYLineAndShapeRenderer)chart.getXYPlot().getRenderer()).setSeriesShape(i, this.beaconShapes.get(i));
        }
        return chart;
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return false;
    }
}

