/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.LogStatisticsItem;
import pt.lsts.neptus.mra.MRAChartPanel;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.plots.TimedXYDataItem;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.chart.LLFChart;

public abstract class MRA2DPlot
implements LLFChart,
LogMarkerListener {
    MRAPanel mraPanel;
    private XYSeries markerSeries;
    private LsfIndex index;
    protected double timestep = 0.0;
    JFreeChart chart;
    protected LinkedHashMap<String, LinkedHashMap<Long, Point2D.Double>> series = new LinkedHashMap();
    protected LinkedHashMap<String, Long> lastAddedPoints = new LinkedHashMap();

    public MRA2DPlot(MRAPanel panel) {
        this.mraPanel = panel;
    }

    @Override
    public String getName() {
        return PluginUtils.getPluginName(this.getClass());
    }

    public String getTitle() {
        return this.getName() + " plot";
    }

    public void addValue(long timeMillis, double x, double y, String src, String variable) {
        String seriesName = src + "." + I18n.text(variable);
        if (!this.series.containsKey(seriesName)) {
            this.series.put(seriesName, new LinkedHashMap());
        }
        this.series.get(seriesName).put(timeMillis, new Point2D.Double(x, y));
        this.lastAddedPoints.put(seriesName, timeMillis);
    }

    @Override
    public Component getComponent(IMraLogGroup source, double timestep) {
        return new MRAChartPanel(this, source, this.mraPanel);
    }

    @Override
    public final boolean canBeApplied(IMraLogGroup source) {
        return this.canBeApplied(source.getLsfIndex());
    }

    public abstract boolean canBeApplied(LsfIndex var1);

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("images/menus/graph2.png");
    }

    @Override
    public Double getDefaultTimeStep() {
        return 0.1;
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return true;
    }

    public String getXAxisName() {
        return "X";
    }

    public String getYAxisName() {
        return "Y";
    }

    public JFreeChart createChart() {
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (String k : this.series.keySet()) {
            XYSeries ser = new XYSeries((Comparable)((Object)k));
            for (long time : this.series.get(k).keySet()) {
                TimedXYDataItem item = new TimedXYDataItem(this.series.get(k).get(time).getX(), this.series.get(k).get(time).getY(), time, "");
                ser.add((XYDataItem)item);
            }
            dataset.addSeries(ser);
        }
        JFreeChart chart = ChartFactory.createScatterPlot((String)I18n.text(this.getTitle()), (String)I18n.text(this.getXAxisName()), (String)I18n.text(this.getYAxisName()), (XYDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            ((XYLineAndShapeRenderer)chart.getXYPlot().getRenderer()).setSeriesShape(i, (Shape)new Ellipse2D.Double(0.0, 0.0, 3.0, 3.0));
        }
        ((XYLineAndShapeRenderer)chart.getXYPlot().getRenderer()).setSeriesToolTipGenerator(0, new XYToolTipGenerator(){

            public String generateToolTip(XYDataset arg0, int arg1, int arg2) {
                LocationType loc = new LocationType(arg0.getX(arg1, arg2).doubleValue(), arg0.getY(arg1, arg2).doubleValue());
                return loc.getLatitudeAsPrettyString() + " / " + loc.getLongitudeAsPrettyString();
            }
        });
        this.markerSeries = null;
        return chart;
    }

    @Override
    public final JFreeChart getChart(IMraLogGroup source, double timestep) {
        this.timestep = timestep;
        this.index = source.getLsfIndex();
        this.series.clear();
        this.process(this.index);
        this.chart = this.createChart();
        for (LogMarker marker : this.mraPanel.getMarkers()) {
            try {
                this.addLogMarker(marker);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.chart;
    }

    public abstract void process(LsfIndex var1);

    @Override
    public Vector<LogStatisticsItem> getStatistics() {
        return null;
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.CHART;
    }

    @Override
    public void onCleanup() {
        this.mraPanel = null;
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }

    public XYSeries getMarkerSeries() {
        if (this.markerSeries == null && this.chart != null) {
            this.markerSeries = new XYSeries((Comparable)((Object)I18n.text("Marks")));
            XYSeriesCollection dataset = (XYSeriesCollection)this.chart.getXYPlot().getDataset();
            dataset.addSeries(this.markerSeries);
            ((XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer()).setSeriesShape(dataset.indexOf(this.markerSeries.getKey()), (Shape)new Ellipse2D.Double(0.0, 0.0, 5.0, 5.0));
            ((XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer()).setSeriesItemLabelsVisible(dataset.indexOf(this.markerSeries.getKey()), true);
            ((XYLineAndShapeRenderer)this.chart.getXYPlot().getRenderer()).setSeriesItemLabelGenerator(dataset.indexOf(this.markerSeries.getKey()), new XYItemLabelGenerator(){

                public String generateLabel(XYDataset arg0, int arg1, int arg2) {
                    return ((TimedXYDataItem)((MRA2DPlot)MRA2DPlot.this).markerSeries.getDataItem((int)arg2)).label;
                }
            });
        }
        return this.markerSeries;
    }
}

