/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.util.LinkedHashMap;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;

public abstract class MRACombinedPlot
extends MRATimeSeriesPlot {
    CombinedDomainXYPlot combinedPlot;

    public MRACombinedPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public JFreeChart createChart() {
        LinkedHashMap<String, TimeSeriesCollection> timeSeriesCollections = new LinkedHashMap<String, TimeSeriesCollection>();
        this.combinedPlot = new CombinedDomainXYPlot((ValueAxis)new DateAxis(I18n.text("Time Of Day")));
        for (String seriesName : this.series.keySet()) {
            if (this.forbiddenSeries.contains(seriesName)) continue;
            String plot = seriesName.split("\\.")[0];
            if (!timeSeriesCollections.containsKey(plot)) {
                timeSeriesCollections.put(plot, new TimeSeriesCollection());
            }
            ((TimeSeriesCollection)timeSeriesCollections.get(plot)).addSeries((TimeSeries)this.series.get(seriesName));
        }
        for (String plotName : timeSeriesCollections.keySet()) {
            this.combinedPlot.add(ChartFactory.createTimeSeriesChart((String)plotName, (String)I18n.text("Time Of Day"), (String)plotName, (XYDataset)((XYDataset)timeSeriesCollections.get(plotName)), (boolean)true, (boolean)true, (boolean)false).getXYPlot());
        }
        for (LogMarker marker : this.mraPanel.getMarkers()) {
            this.addLogMarker(marker);
        }
        return new JFreeChart((Plot)this.combinedPlot);
    }

    @Override
    public void addLogMarker(LogMarker e) {
        if (this.combinedPlot != null) {
            for (Object plot : this.combinedPlot.getSubplots()) {
                ValueMarker vm = new ValueMarker(e.getTimestamp() - (double)localTimeOffset);
                vm.setLabel(e.getLabel());
                ((XYPlot)plot).addDomainMarker((Marker)vm);
            }
        }
    }
}

