/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.LogStatisticsItem;
import pt.lsts.neptus.mra.MRAChartPanel;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.chart.LLFChart;

public abstract class MRAGanttPlot
implements LLFChart,
LogMarkerListener {
    protected Vector<String> forbiddenSeries = new Vector();
    protected LsfIndex index;
    protected double timestep = 0.0;
    protected TaskSeriesCollection tsc = new TaskSeriesCollection();
    protected LinkedHashMap<String, TaskSeries> series = new LinkedHashMap();
    protected LinkedHashMap<String, String> statePerTimeline = new LinkedHashMap();
    protected JFreeChart chart = null;
    protected MRAPanel mraPanel;
    protected static final long localTimeOffset = Calendar.getInstance().get(16) + Calendar.getInstance().get(15);

    public MRAGanttPlot(MRAPanel panel) {
        this.mraPanel = panel;
    }

    public Vector<String> getForbiddenSeries() {
        return this.forbiddenSeries;
    }

    @Override
    public String getName() {
        return PluginUtils.getPluginName(this.getClass());
    }

    public String getTitle() {
        return this.getName() + " plot";
    }

    public final Collection<String> getSeriesNames() {
        LinkedHashSet<String> series = new LinkedHashSet<String>();
        series.addAll(this.series.keySet());
        series.addAll(this.forbiddenSeries);
        Vector<String> col = new Vector<String>();
        col.addAll(series);
        Collections.sort(col);
        return col;
    }

    public void addTrace(String trace) {
        this.series.put(trace, new TaskSeries(trace));
        this.tsc.add(this.series.get(trace));
    }

    public void startActivity(double time, String trace, String state) {
        if (this.forbiddenSeries.contains(trace)) {
            return;
        }
        if (!this.series.containsKey(trace)) {
            this.addTrace(trace);
        }
        if (this.statePerTimeline.containsKey(trace)) {
            if (this.statePerTimeline.get(trace).equals(state)) {
                return;
            }
            this.endActivity(time, trace);
        }
        this.statePerTimeline.put(trace, state);
        Task t = this.series.get(trace).get(state);
        if (t == null) {
            long start = (long)(this.mraPanel.getSource().getLsfIndex().getStartTime() * 1000.0);
            long end = (long)(this.mraPanel.getSource().getLsfIndex().getEndTime() * 1000.0);
            t = new Task(state, new Date(start - localTimeOffset), new Date(end - localTimeOffset));
            this.series.get(trace).add(t);
        }
        t.addSubtask(new Task(state + time, new Date((long)(time * 1000.0 - (double)localTimeOffset)), new Date((long)(time * 1000.0 - (double)localTimeOffset))));
    }

    private Task setEndTime(Task t, double time) {
        TimePeriod tp = t.getDuration();
        t.setDuration((TimePeriod)new SimpleTimePeriod(tp.getStart(), new Date((long)(time * 1000.0 - (double)localTimeOffset))));
        return t;
    }

    public void endActivity(double time, String trace) {
        if (this.forbiddenSeries.contains(trace) || !this.series.containsKey(trace)) {
            return;
        }
        Task t = this.series.get(trace).get(this.statePerTimeline.get(trace));
        if (t.getSubtaskCount() > 0) {
            t = t.getSubtask(t.getSubtaskCount() - 1);
        }
        this.setEndTime(t, time);
        this.statePerTimeline.put(trace, null);
    }

    @Override
    public JComponent getComponent(IMraLogGroup source, double timestep) {
        MRAChartPanel fcp = new MRAChartPanel(this, source, this.mraPanel);
        return fcp;
    }

    @Override
    public final boolean canBeApplied(IMraLogGroup source) {
        return this.canBeApplied(source.getLsfIndex());
    }

    public abstract boolean canBeApplied(LsfIndex var1);

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("pt/lsts/neptus/mra/plots/clock-frame.png");
    }

    @Override
    public Double getDefaultTimeStep() {
        return 0.1;
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return false;
    }

    public JFreeChart createChart() {
        return ChartFactory.createGanttChart((String)I18n.text(this.getTitle()), (String)I18n.text(this.getVerticalAxisName()), (String)I18n.text(this.getHorizontalAxisName()), (IntervalCategoryDataset)this.tsc, (boolean)true, (boolean)true, (boolean)false);
    }

    public String getVerticalAxisName() {
        return "Time of the day";
    }

    public String getHorizontalAxisName() {
        return "";
    }

    @Override
    public JFreeChart getChart(IMraLogGroup source, double timestep) {
        if (this.chart != null) {
            return this.chart;
        }
        this.timestep = timestep;
        this.index = source.getLsfIndex();
        this.tsc = new TaskSeriesCollection();
        this.series.clear();
        this.process(this.index);
        this.chart = this.createChart();
        for (LogMarker marker : this.mraPanel.getMarkers()) {
            this.addLogMarker(marker);
        }
        return this.chart;
    }

    public abstract void process(LsfIndex var1);

    @Override
    public Vector<LogStatisticsItem> getStatistics() {
        return null;
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.CHART;
    }

    @Override
    public void onCleanup() {
        this.mraPanel = null;
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }

    @Override
    public void addLogMarker(LogMarker e) {
        ValueMarker marker = new ValueMarker(e.getTimestamp() - (double)localTimeOffset);
        marker.setLabel(e.getLabel());
        this.chart.getCategoryPlot().addRangeMarker((Marker)marker);
    }

    @Override
    public void removeLogMarker(LogMarker e) {
        if (this.chart != null) {
            this.chart.getCategoryPlot().clearRangeMarkers();
            for (LogMarker m : this.mraPanel.getMarkers()) {
                this.addLogMarker(m);
            }
        }
    }

    @Override
    public void GotoMarker(LogMarker marker) {
    }
}

