/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.LogStatisticsItem;
import pt.lsts.neptus.mra.MRAChartPanel;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.chart.LLFChart;

public abstract class MRATimeSeriesPlot
implements LLFChart,
LogMarkerListener {
    protected Vector<String> forbiddenSeries = new Vector();
    protected LsfIndex index;
    protected double timestep = 0.0;
    protected TimeSeriesCollection tsc = new TimeSeriesCollection();
    protected LinkedHashMap<String, TimeSeries> series = new LinkedHashMap();
    protected JFreeChart chart;
    protected MRAPanel mraPanel;
    protected static final long localTimeOffset = Calendar.getInstance().get(16) + Calendar.getInstance().get(15);
    protected static Color[] seriesColors = new Color[]{Color.red.darker(), Color.blue.darker(), Color.green.darker(), Color.orange, Color.cyan.darker(), Color.gray.darker(), Color.magenta.darker(), Color.blue.brighter().brighter(), Color.red.brighter().brighter(), Color.green.brighter().brighter(), Color.black, Color.pink, Color.yellow.darker(), Color.cyan, Color.magenta};

    public MRATimeSeriesPlot(MRAPanel panel) {
        this.mraPanel = panel;
    }

    public Vector<String> getForbiddenSeries() {
        return this.forbiddenSeries;
    }

    @Override
    public String getName() {
        return PluginUtils.getPluginName(this.getClass());
    }

    public String getTitle() {
        return I18n.textf("%plotname plot", this.getName());
    }

    public final Collection<String> getSeriesNames() {
        LinkedHashSet<String> series = new LinkedHashSet<String>();
        series.addAll(this.series.keySet());
        series.addAll(this.forbiddenSeries);
        Vector<String> col = new Vector<String>();
        col.addAll(series);
        Collections.sort(col);
        return col;
    }

    public void addTrace(String trace) {
        this.series.put(trace, new TimeSeries(trace));
        this.tsc.addSeries(this.series.get(trace));
    }

    public void addValue(long timeMillis, String trace, double value) {
        if (this.forbiddenSeries.contains(trace)) {
            return;
        }
        if (!this.series.containsKey(trace)) {
            this.addTrace(trace);
        }
        this.series.get(trace).addOrUpdate((RegularTimePeriod)new Millisecond(new Date(timeMillis), TimeZone.getTimeZone("UTC")), value);
    }

    @Override
    public Component getComponent(IMraLogGroup source, double timestep) {
        MRAChartPanel fcp = new MRAChartPanel(this, source, this.mraPanel);
        return fcp;
    }

    @Override
    public final boolean canBeApplied(IMraLogGroup source) {
        return this.canBeApplied(source.getLsfIndex());
    }

    public abstract boolean canBeApplied(LsfIndex var1);

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("images/menus/graph2.png");
    }

    @Override
    public Double getDefaultTimeStep() {
        return 0.1;
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return true;
    }

    public JFreeChart createChart() {
        return ChartFactory.createTimeSeriesChart((String)I18n.text(this.getTitle()), (String)I18n.text(this.getVerticalAxisName()), (String)I18n.text(this.getHorizontalAxisName()), (XYDataset)this.tsc, (boolean)true, (boolean)true, (boolean)false);
    }

    public String getHorizontalAxisName() {
        return "";
    }

    public String getVerticalAxisName() {
        return I18n.text("Time of day");
    }

    @Override
    public JFreeChart getChart(IMraLogGroup source, double timestep) {
        this.timestep = timestep;
        this.index = source.getLsfIndex();
        this.tsc = new TimeSeriesCollection();
        this.series.clear();
        this.process(this.index);
        this.chart = this.createChart();
        XYItemRenderer r = this.chart.getXYPlot().getRenderer();
        if (r != null) {
            for (int i = 0; i < this.tsc.getSeriesCount(); ++i) {
                r.setSeriesPaint(i, (Paint)seriesColors[i % seriesColors.length]);
            }
        }
        for (LogMarker marker : this.mraPanel.getMarkers()) {
            this.addLogMarker(marker);
        }
        return this.chart;
    }

    public abstract void process(LsfIndex var1);

    @Override
    public Vector<LogStatisticsItem> getStatistics() {
        return null;
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.CHART;
    }

    @Override
    public void onCleanup() {
        this.mraPanel = null;
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }

    @Override
    public void addLogMarker(LogMarker e) {
        ValueMarker marker = new ValueMarker(e.getTimestamp() - (double)localTimeOffset);
        marker.setLabel(e.getLabel());
        if (this.chart != null) {
            this.chart.getXYPlot().addDomainMarker((Marker)marker);
        }
    }

    @Override
    public void removeLogMarker(LogMarker e) {
        if (this.chart != null) {
            this.chart.getXYPlot().clearDomainMarkers();
            for (LogMarker m : this.mraPanel.getMarkers()) {
                this.addLogMarker(m);
            }
        }
    }

    @Override
    public void GotoMarker(LogMarker marker) {
    }
}

