/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.awt.Color;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.primitives.ISortableDraw;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.text.renderers.TextBitmapRenderer;

public class Marker3d
extends AbstractWireframeable
implements ISortableDraw {
    protected String label;
    protected Coord3d center;
    protected org.jzy3d.colors.Color color;

    public Marker3d(String text, Coord3d pos, Color color) {
        this.label = text;
        this.center = pos;
        this.color = new org.jzy3d.colors.Color(color);
    }

    public void draw(GL2 gl, GLU glu, Camera cam) {
        if (this.transform != null) {
            this.transform.execute(gl);
        }
        gl.glPointSize(3.0f);
        gl.glBegin(0);
        gl.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
        gl.glVertex3f(this.center.x, this.center.y, this.center.z);
        gl.glEnd();
        TextBitmapRenderer txt = new TextBitmapRenderer();
        txt.drawText(gl, glu, cam, this.label, this.center, Halign.LEFT, Valign.CENTER, this.color);
    }

    public double getDistance(Camera camera) {
        return this.center.distance(camera.getEye());
    }

    public double getShortestDistance(Camera camera) {
        return this.getDistance(camera);
    }

    public double getLongestDistance(Camera camera) {
        return this.getDistance(camera);
    }
}

