/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.data.Pair;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.LogStatisticsItem;
import pt.lsts.neptus.mra.MRAChartPanel;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.chart.LLFChart;

public abstract class PiePlot
implements LLFChart,
LogMarkerListener {
    protected MRAPanel mraPanel;
    protected LsfIndex index;
    protected double timestep = 0.0;
    protected JFreeChart chart;
    protected LinkedHashMap<String, Double> sums = new LinkedHashMap();

    public PiePlot(MRAPanel panel) {
        this.mraPanel = panel;
    }

    @Override
    public String getName() {
        return PluginUtils.getPluginName(this.getClass());
    }

    public String getTitle() {
        return I18n.textf("%plotname plot", this.getName());
    }

    public void incValue(String name) {
        this.addValue(name, 1.0);
    }

    public void cleanupSeries(double otherRatio) {
        Pair pair;
        Vector<Pair<String, Double>> values = new Vector<Pair<String, Double>>();
        double totalSum = 0.0;
        for (Map.Entry<String, Double> k : this.sums.entrySet()) {
            totalSum += k.getValue().doubleValue();
            values.add(new Pair<String, Double>(k.getKey(), k.getValue()));
        }
        Collections.sort(values, new Comparator<Pair<String, Double>>(){

            @Override
            public int compare(Pair<String, Double> o1, Pair<String, Double> o2) {
                return o1.second().compareTo(o2.second());
            }
        });
        double otherSum = 0.0;
        Iterator<Object> i$ = values.iterator();
        while (i$.hasNext() && (otherSum + (Double)(pair = (Pair)i$.next()).second()) / totalSum < otherRatio) {
            otherSum += ((Double)pair.second()).doubleValue();
            this.sums.remove(pair.first());
        }
        this.sums.put("Other", otherSum);
        for (Map.Entry entry : this.sums.entrySet()) {
            this.sums.put((String)entry.getKey(), (Double)entry.getValue() / totalSum * 100.0);
        }
    }

    public void addValue(String name, double amount) {
        if (!this.sums.containsKey(name)) {
            this.sums.put(name, 0.0);
        }
        this.sums.put(name, this.sums.get(name) + amount);
    }

    @Override
    public Component getComponent(IMraLogGroup source, double timestep) {
        return new MRAChartPanel(this, source, this.mraPanel);
    }

    @Override
    public final boolean canBeApplied(IMraLogGroup source) {
        return this.canBeApplied(source.getLsfIndex());
    }

    public abstract boolean canBeApplied(LsfIndex var1);

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("pt/lsts/neptus/mra/plots/chart-pie.png");
    }

    @Override
    public Double getDefaultTimeStep() {
        return 0.1;
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return false;
    }

    public JFreeChart createChart() {
        DefaultPieDataset dataSet = new DefaultPieDataset();
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.sums.keySet());
        boolean beginning = true;
        while (!keys.isEmpty()) {
            int index = 0;
            if (!beginning) {
                index = keys.size() - 1;
            }
            String key = (String)keys.get(index);
            keys.remove(index);
            beginning = !beginning;
            dataSet.setValue((Comparable)((Object)key), (Number)this.sums.get(key));
        }
        JFreeChart chart = ChartFactory.createPieChart((String)this.getTitle(), (PieDataset)dataSet, (boolean)true, (boolean)true, (boolean)false);
        return chart;
    }

    @Override
    public final JFreeChart getChart(IMraLogGroup source, double timestep) {
        this.timestep = timestep;
        this.index = source.getLsfIndex();
        this.process(this.index);
        this.chart = this.createChart();
        for (LogMarker marker : this.mraPanel.getMarkers()) {
            this.addLogMarker(marker);
        }
        return this.chart;
    }

    public abstract void process(LsfIndex var1);

    @Override
    public Vector<LogStatisticsItem> getStatistics() {
        return null;
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.CHART;
    }

    @Override
    public void onCleanup() {
        this.mraPanel = null;
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }

    @Override
    public void addLogMarker(LogMarker marker) {
    }

    @Override
    public void removeLogMarker(LogMarker marker) {
    }

    @Override
    public void GotoMarker(LogMarker marker) {
    }
}

