/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.ChartLauncher;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.ColorMapRainbow;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.global.Settings;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.builder.Builder;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Scatter;
import org.jzy3d.plot3d.primitives.Shape;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.legends.Legend;
import org.jzy3d.plot3d.rendering.legends.colorbars.ColorbarLegend;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.colormap.DataDiscretizer;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.plots.Marker3d;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(name="3D Plot", icon="pt/lsts/neptus/mra/plots/3d.png", active=false)
public class Plot3D
extends SimpleMRAVisualization
implements LogMarkerListener {
    private static final long serialVersionUID = 1L;
    protected boolean inited = false;
    protected Chart chart = null;
    protected JToggleButton zExaggerationToggle;
    protected JToggleButton bathymetryToggle;
    protected JToggleButton pathToggle;
    protected JToggleButton markersToggle;
    protected Shape surface = null;
    protected LineStrip path = null;
    protected Scatter gpsScatter = null;
    protected LocationType ref;
    protected Vector<Marker3d> markers = new Vector();

    public Plot3D(MRAPanel panel) {
        super(panel);
        this.panel = panel;
        this.setLayout(new BorderLayout());
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLog("EstimatedState") != null;
    }

    protected void addChart() {
        Settings.getInstance().setHardwareAccelerated(true);
        this.chart = new Chart(Quality.Advanced, "swing");
        this.ref = IMCUtils.getLocation(this.source.getLsfIndex().getMessage(this.source.getLsfIndex().getFirstMessageOfType("EstimatedState")));
        this.path = new LineStrip();
        Coord3d lastCoord = new Coord3d();
        for (IMCMessage m : this.source.getLsfIndex().getIterator("EstimatedState", 0, 1000L)) {
            LocationType loc = IMCUtils.getLocation(m);
            double[] offsets = loc.getOffsetFrom(this.ref);
            double phi = Math.min(Math.toDegrees(m.getDouble("theta")), 10.0);
            int sb = (phi = Math.max(phi, -10.0)) <= 0.0 ? 0 : (int)(phi / 10.0 * 255.0);
            int bb = phi >= 0.0 ? 0 : (int)(phi / -10.0 * 255.0);
            double depth = -loc.getDepth();
            if (m.getTypeOf("ref") != null) {
                depth = -m.getDouble("z");
            }
            lastCoord = new Coord3d(-offsets[0], offsets[1], depth);
            this.path.add(new Point(lastCoord, new org.jzy3d.colors.Color(bb, sb, 0), 1.0f));
        }
        this.path.add(new Point(lastCoord, new org.jzy3d.colors.Color(0, 0, 0, 0), 0.0f));
        this.path.add(new Point(new Coord3d(0.0f, 0.0f, 0.0f), new org.jzy3d.colors.Color(0, 0, 0, 0), 0.0f));
        this.path.setWidth(2.0f);
        this.chart.getScene().add((AbstractDrawable)this.path);
        Thread t = new Thread(new Runnable(){
            int bathymCellWidth = 1;
            DataDiscretizer dd = new DataDiscretizer(this.bathymCellWidth);

            @Override
            public void run() {
                DataDiscretizer.DataPoint[] data;
                double[] offsets;
                if (Plot3D.this.source.getLog("BottomDistance") != null) {
                    int dvlId = Plot3D.this.source.getLsfIndex().getEntityId("DVL");
                    int bDistanceId = Plot3D.this.source.getLsfIndex().getDefinitions().getMessageId("BottomDistance");
                    int eStateId = Plot3D.this.source.getLsfIndex().getDefinitions().getMessageId("EstimatedState");
                    int lastStateIndex = 0;
                    int i = Plot3D.this.source.getLsfIndex().getNextMessageOfEntity(bDistanceId, dvlId, 0);
                    while (i != -1) {
                        IMCMessage bDistance = Plot3D.this.source.getLsfIndex().getMessage(i);
                        int stateIndex = Plot3D.this.source.getLsfIndex().getMessageAtOrAfer(eStateId, 255, lastStateIndex, bDistance.getTimestamp());
                        if (stateIndex != -1) {
                            IMCMessage state = Plot3D.this.source.getLsfIndex().getMessage(stateIndex);
                            LocationType l = new LocationType();
                            l.setLatitudeRads(state.getDouble("lat"));
                            l.setLongitudeRads(state.getDouble("lon"));
                            l.translatePosition(state.getDouble("x"), state.getDouble("y"), 0.0);
                            offsets = l.getOffsetFrom(Plot3D.this.ref);
                            lastStateIndex = stateIndex;
                            this.dd.addPoint(-offsets[0], offsets[1], -state.getDouble("z") - bDistance.getDouble("value"));
                        }
                        i = Plot3D.this.source.getLsfIndex().getNextMessageOfEntity(bDistanceId, dvlId, i);
                    }
                } else {
                    for (IMCMessage state : Plot3D.this.source.getLsfIndex().getIterator("EstimatedState", 0, 100L)) {
                        if (state.getTypeOf("alt") == null) continue;
                        double alt = state.getDouble("alt");
                        double depth = state.getDouble("depth");
                        double pitch = Math.toDegrees(state.getDouble("theta"));
                        if (alt == -1.0 || !(Math.abs(pitch) < 4.0) || !(depth > MRAProperties.minDepthForBathymetry)) continue;
                        LocationType loc = IMCUtils.getLocation(state);
                        offsets = loc.getOffsetFrom(Plot3D.this.ref);
                        this.dd.addPoint(-offsets[0], offsets[1], -alt - depth);
                    }
                }
                if ((data = this.dd.getDataPoints()).length == 0) {
                    return;
                }
                ArrayList<Coord3d> coords = new ArrayList<Coord3d>();
                for (DataDiscretizer.DataPoint p : data) {
                    coords.add(new Coord3d(p.getPoint2D().getX(), p.getPoint2D().getY(), p.getValue()));
                }
                Plot3D.this.surface = Builder.buildDelaunay(coords);
                Plot3D.this.surface.setColorMapper(new ColorMapper((IColorMap)new ColorMapRainbow(), Plot3D.this.surface.getBounds().getZmin(), Plot3D.this.surface.getBounds().getZmax(), new org.jzy3d.colors.Color(1.0f, 0.5f, 0.5f, 0.5f)));
                Plot3D.this.surface.setWireframeDisplayed(false);
                Plot3D.this.surface.setLegend((Legend)new ColorbarLegend((AbstractDrawable)Plot3D.this.surface, Plot3D.this.chart.getView().getAxe().getLayout().getZTickProvider(), Plot3D.this.chart.getView().getAxe().getLayout().getZTickRenderer()));
                Plot3D.this.surface.setLegendDisplayed(true);
                Plot3D.this.bathymetryToggle.setEnabled(true);
            }
        });
        t.setName("Plot3D thread");
        t.setDaemon(true);
        t.start();
        Vector<Coord3d> gpsFixes = new Vector<Coord3d>();
        for (IMCMessage fix : this.source.getLsfIndex().getIterator("GpsFix")) {
            if (!((Boolean)fix.getBitmask("validity").get("VALID_POS")).booleanValue()) continue;
            LocationType l = new LocationType();
            l.setLatitudeRads(fix.getDouble("lat"));
            l.setLongitudeRads(fix.getDouble("lon"));
            double[] offsets = l.getOffsetFrom(this.ref);
            if (!this.path.getBounds().getXRange().contains(offsets[0]) || !this.path.getBounds().getYRange().contains(offsets[1])) continue;
            gpsFixes.add(new Coord3d(-offsets[0], offsets[1], 0.0));
        }
        this.gpsScatter = new Scatter(gpsFixes.toArray(new Coord3d[0]), new org.jzy3d.colors.Color(100, 100, 200, 128), 5.0f);
        this.chart.getScene().add((AbstractDrawable)this.gpsScatter);
        this.add((Component)this.chart.getCanvas());
        this.chart.getView().setMaximized(true);
        this.chart.render();
        ChartLauncher.configureControllers((Chart)this.chart, (String)"chart", (boolean)true, (boolean)false);
    }

    @Override
    public JComponent getVisualization(IMraLogGroup source, double timestep) {
        return this;
    }

    protected JPanel createToolbar() {
        JPanel toolbar = new JPanel();
        this.zExaggerationToggle = new JToggleButton(I18n.text("Z Exaggeration"));
        this.zExaggerationToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Plot3D.this.chart.getView().setSquared(Plot3D.this.zExaggerationToggle.isSelected());
            }
        });
        this.zExaggerationToggle.setSelected(true);
        toolbar.add(this.zExaggerationToggle);
        this.bathymetryToggle = new JToggleButton(I18n.text("Bathymetry"));
        this.bathymetryToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Plot3D.this.bathymetryToggle.isSelected()) {
                    Plot3D.this.chart.getScene().add((AbstractDrawable)Plot3D.this.surface);
                } else {
                    Plot3D.this.chart.getScene().remove((AbstractDrawable)Plot3D.this.surface);
                }
            }
        });
        this.bathymetryToggle.setEnabled(false);
        toolbar.add(this.bathymetryToggle);
        this.pathToggle = new JToggleButton(I18n.text("Vehicle path"));
        this.pathToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Plot3D.this.pathToggle.isSelected()) {
                    Plot3D.this.chart.getScene().add((AbstractDrawable)Plot3D.this.path);
                    Plot3D.this.chart.getScene().add((AbstractDrawable)Plot3D.this.gpsScatter);
                } else {
                    Plot3D.this.chart.getScene().remove((AbstractDrawable)Plot3D.this.path);
                    Plot3D.this.chart.getScene().remove((AbstractDrawable)Plot3D.this.gpsScatter);
                }
            }
        });
        this.pathToggle.setSelected(true);
        toolbar.add(this.pathToggle);
        this.markersToggle = new JToggleButton(I18n.text("Markers"));
        this.markersToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Plot3D.this.markersToggle.isSelected()) {
                    for (Marker3d m : Plot3D.this.markers) {
                        Plot3D.this.chart.getScene().add((AbstractDrawable)m);
                    }
                } else {
                    for (Marker3d m : Plot3D.this.markers) {
                        Plot3D.this.chart.getScene().remove((AbstractDrawable)m);
                    }
                }
            }
        });
        this.markersToggle.setSelected(true);
        toolbar.add(this.markersToggle);
        return toolbar;
    }

    @Override
    public void onCleanup() {
        super.onCleanup();
        if (this.chart != null) {
            this.chart.stopAnimator();
            this.chart.clear();
            this.chart.dispose();
        }
    }

    @Override
    public void onHide() {
        super.onHide();
        this.chart.stopAnimator();
        this.chart.clear();
        this.chart.dispose();
        this.removeAll();
        this.chart = null;
    }

    @Override
    public void onShow() {
        super.onShow();
        this.addChart();
        if (this.panel != null) {
            for (LogMarker m : this.panel.getMarkers()) {
                this.addLogMarker(m);
            }
        }
        this.add((Component)this.createToolbar(), "South");
    }

    @Override
    public void addLogMarker(LogMarker marker) {
        if (this.chart == null) {
            return;
        }
        IMCMessage state = this.source.getLsfIndex().getMessageAtOrAfter("EstimatedState", 0, 255, marker.getTimestamp() / 1000.0);
        if (state == null) {
            return;
        }
        double depth = state.getDouble("depth");
        if (state.getTypeOf("alt") == null) {
            depth = state.getDouble("z");
        }
        LocationType location = IMCUtils.getLocation(state);
        double[] xyz = location.getOffsetFrom(this.ref);
        Marker3d m = new Marker3d(marker.getLabel(), new Coord3d(-xyz[0], xyz[1], -depth), Color.black);
        this.markers.add(m);
        this.chart.getScene().add((AbstractDrawable)m);
    }

    @Override
    public void GotoMarker(LogMarker marker) {
    }

    @Override
    public void removeLogMarker(LogMarker marker) {
        for (int i = 0; i < this.markers.size(); ++i) {
            if (!this.markers.get((int)i).label.equals(marker.getLabel())) continue;
            this.chart.getScene().remove((AbstractDrawable)this.markers.get(i));
            this.markers.remove(i);
            --i;
        }
    }
}

