/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.gui.Timeline;
import pt.lsts.neptus.gui.TimelineChangeListener;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.lsf.LsfMraLog;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;

public class ReplayPlot
extends MRATimeSeriesPlot
implements TimelineChangeListener {
    Timeline timeline;
    long firstTimestamp;
    private long lastTimestamp;
    String[] fieldsToPlot;
    LinkedHashMap<String, IMraLog> parsers = new LinkedHashMap();

    public ReplayPlot(MRAPanel panel, String[] fieldsToPlot) {
        super(panel);
        this.fieldsToPlot = fieldsToPlot;
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        for (String field : this.fieldsToPlot) {
            String messageName = field.split("\\.")[0];
            if (index.getFirstMessageOfType(messageName) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public void process(LsfIndex source) {
        this.firstTimestamp = (long)(source.timeOf(0) * 1000.0);
        this.lastTimestamp = (long)(source.timeOf(source.getNumberOfMessages() - 2) * 1000.0);
        this.timeline = new Timeline(0, (int)(this.lastTimestamp - this.firstTimestamp), 24, 1000, false);
        this.timeline.getSlider().setValue(0);
        this.timeline.addTimelineChangeListener(this);
        for (String field : this.fieldsToPlot) {
            String messageName = field.split("\\.")[0];
            this.parsers.put(messageName, new LsfMraLog(this.index, messageName));
        }
    }

    @Override
    public Component getComponent(IMraLogGroup source, double timestep) {
        Component comp = super.getComponent(source, timestep);
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        panel.add(comp, "w 100%, h 100%, wrap");
        panel.add((Component)this.timeline, "w 100%, h 80");
        return panel;
    }

    @Override
    public String getName() {
        return Arrays.toString(this.fieldsToPlot);
    }

    @Override
    public void timelineChanged(int value) {
        try {
            long ts = this.firstTimestamp + (long)value;
            for (String field : this.fieldsToPlot) {
                String messageName = field.split("\\.")[0];
                String fieldName = field.split("\\.")[1];
                this.addValue(this.firstTimestamp + (long)value, field, this.parsers.get(messageName).getEntryAtOrAfter(ts).getDouble(fieldName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTimelineVisible(boolean visible) {
        this.timeline.setVisible(visible);
    }
}

