/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Salinity;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.TimedXYDataItem;
import pt.lsts.neptus.mra.plots.XYPlot;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(name="Salinity Vs Depth plot", active=false)
public class SalinityVsDepthPlot
extends XYPlot {
    public SalinityVsDepthPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public String getName() {
        return I18n.text("Salinity VS Depth");
    }

    @Override
    public void process(LsfIndex source) {
        int ctdId = source.getEntityId("CTD");
        LsfIterator tempIt = source.getIterator(Salinity.class);
        for (Salinity temp : tempIt) {
            IMCMessage msg;
            if (temp.getSrcEnt() != ctdId || (msg = source.getMessageAt("EstimatedState", temp.getTimestamp())) == null || !(msg.getDouble("depth") > 0.5)) continue;
            this.addValue(temp.getTimestampMillis(), -msg.getDouble("depth"), temp.getValue(), temp.getSourceName(), "Salinity");
        }
    }

    @Override
    public void addLogMarker(LogMarker marker) {
        try {
            XYSeries markerSeries = this.getMarkerSeries();
            IMCMessage es = this.mraPanel.getSource().getLog("EstimatedState").getEntryAtOrAfter(new Double(marker.getTimestamp()).longValue());
            IMCMessage sal = this.mraPanel.getSource().getLog("Salinity").getEntryAtOrAfter(new Double(marker.getTimestamp()).longValue());
            if (markerSeries != null) {
                markerSeries.add((XYDataItem)new TimedXYDataItem(-es.getDouble("depth"), ((Salinity)sal).getValue(), sal.getTimestampMillis(), marker.getLabel()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"EstimatedState", "Salinity"});
    }
}

