/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;
import pt.lsts.neptus.mra.plots.ScriptEnvironment;
import pt.lsts.neptus.util.GuiUtils;

public class ScriptedPlot
extends MRATimeSeriesPlot {
    protected LinkedHashMap<String, String> traces = new LinkedHashMap();
    protected LinkedHashMap<String, String> hiddenTraces = new LinkedHashMap();
    protected LinkedHashMap<String, Script> scripts = new LinkedHashMap();
    protected String init = null;
    protected String end = null;
    protected Script initScript = null;
    protected Script endScript = null;
    protected ScriptableIndex scIndex = null;
    protected Context context;
    protected Global global;
    protected LsfIndex index;
    protected String title = this.getClass().getName();
    protected ScriptEnvironment env = new ScriptEnvironment();

    @Override
    public String getName() {
        return I18n.text(this.title);
    }

    @Override
    public String getTitle() {
        return I18n.textf("%plotname plot", this.title);
    }

    public ScriptedPlot(MRAPanel panel, String scriptFile) {
        super(panel);
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(scriptFile));
            this.title = reader.readLine();
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
                while (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1) + reader.readLine();
                }
                String[] parts = line.trim().split(":");
                String script = parts[1];
                script = script.replaceAll("\\$\\{([^\\}]*)\\}", "log.val(\"$1\")");
                script = script.replaceAll("mark\\(([^\\)]+)\\)", "log.mark($1)");
                script = script.replaceAll("\\$time", "log.time()");
                script = script.replaceAll("\\$(\\w+)", "env[\"$1\"]");
                if (parts[0].isEmpty()) {
                    this.hiddenTraces.put(parts[1], script);
                    continue;
                }
                if (parts[0].equals("init")) {
                    this.init = script;
                    continue;
                }
                if (parts[0].equals("end")) {
                    this.end = script;
                    continue;
                }
                this.traces.put(parts[0], script);
            }
            reader.close();
        }
        catch (Exception e) {
            GuiUtils.errorMessage(panel, e);
        }
    }

    protected void init() {
        this.context = Context.enter();
        this.context.initStandardObjects();
        this.global = new Global(this.context);
        Object o = Context.javaToJS((Object)this.scIndex, (Scriptable)this.global);
        ScriptableObject.putProperty((Scriptable)this.global, (String)"log", (Object)o);
        ScriptableObject.putProperty((Scriptable)this.global, (String)"env", (Object)((Object)this.env));
        ScriptableObject.putProperty((Scriptable)this.global, (String)"mraPanel", (Object)this.mraPanel);
        if (this.init != null) {
            try {
                this.initScript = this.context.compileString(this.init, "init", 1, null);
            }
            catch (Exception e) {
                GuiUtils.errorMessage(this.mraPanel, "Init script Error", e.getMessage());
                e.printStackTrace();
            }
            NeptusLog.pub().debug((Object)"init");
        }
        if (this.end != null) {
            try {
                this.endScript = this.context.compileString(this.end, "end", 1, null);
            }
            catch (Exception e) {
                GuiUtils.errorMessage(this.mraPanel, "End script Error", e.getMessage());
                e.printStackTrace();
            }
            NeptusLog.pub().debug((Object)"ended.");
        }
        for (Map.Entry<String, String> t : this.traces.entrySet()) {
            String script = t.getValue();
            try {
                this.context.evaluateString((Scriptable)this.global, script, t.getKey(), 1, null);
                this.scripts.put(t.getKey(), this.context.compileString(script, t.getKey(), 1, null));
            }
            catch (Exception e) {
                GuiUtils.errorMessage(this.mraPanel, "Plot script Error", e.getMessage());
                e.printStackTrace();
            }
        }
        for (Map.Entry<String, String> t : this.hiddenTraces.entrySet()) {
            String trace = t.getValue();
            try {
                this.context.evaluateString((Scriptable)this.global, trace, t.getKey(), 1, null);
                this.scripts.put(t.getKey(), this.context.compileString(trace, t.getKey(), 1, null));
            }
            catch (Exception e) {
                GuiUtils.errorMessage(this.mraPanel, "Script Error", e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        this.index = index;
        return true;
    }

    @Override
    public void process(LsfIndex source) {
        this.scIndex = new ScriptableIndex(source, 0);
        this.env = new ScriptEnvironment();
        this.index = source;
        this.init();
        if (this.initScript != null) {
            this.initScript.exec(this.context, (Scriptable)this.global);
        }
        double step = Math.max(this.timestep, 0.05);
        int i = this.index.advanceToTime(0, step);
        while (i != -1) {
            this.scIndex.lsfPos = i;
            for (String trace : this.scripts.keySet()) {
                if (this.traces.containsKey(trace)) {
                    Object ret = this.scripts.get(trace).exec(this.context, (Scriptable)this.global);
                    if (ret == null || !(ret instanceof Number)) continue;
                    double val = ((Number)ret).doubleValue();
                    this.addValue((long)(this.index.timeOf(i) * 1000.0), trace, val);
                    continue;
                }
                this.scripts.get(trace).exec(this.context, (Scriptable)this.global);
            }
            i = this.index.advanceToTime(i, this.index.timeOf(i) + step);
        }
        if (this.endScript != null) {
            this.endScript.exec(this.context, (Scriptable)this.global);
        }
    }

    public class ScriptableIndex {
        protected LsfIndex lsfIndex;
        protected int lsfPos;
        protected int prevPos = 0;

        public ScriptableIndex(LsfIndex source, int curIndex) {
            this.lsfIndex = source;
            this.lsfPos = curIndex;
        }

        public void mark(double time, String label) {
            ScriptedPlot.this.mraPanel.addMarker(new LogMarker(label, time * 1000.0, 0.0, 0.0));
        }

        public void mark(String label) {
            this.mark(this.lsfIndex.timeOf(this.lsfPos), label);
        }

        public double time() {
            return this.lsfIndex.timeOf(this.lsfPos);
        }

        public double val(String expression) {
            String field;
            String entity;
            Pattern p = Pattern.compile("(\\w+)(\\[(\\w+)\\])?\\.(\\w+)");
            Matcher m = p.matcher(expression);
            if (!m.matches()) {
                return Double.NaN;
            }
            String message = m.group(1);
            if (m.groupCount() > 2) {
                entity = m.group(3);
                field = m.group(4);
            } else {
                entity = null;
                field = m.group(2);
            }
            int msgType = ScriptedPlot.this.index.getDefinitions().getMessageId(message);
            if (entity == null) {
                int msgIdx = ScriptedPlot.this.index.getPreviousMessageOfType(msgType, this.lsfPos);
                if (msgIdx == -1) {
                    return Double.NaN;
                }
                return ScriptedPlot.this.index.getMessage(msgIdx).getDouble(field);
            }
            int msgIdx = ScriptedPlot.this.index.getPreviousMessageOfType(msgType, this.lsfPos);
            while (msgIdx >= this.prevPos) {
                if (msgIdx == -1) {
                    return Double.NaN;
                }
                if (ScriptedPlot.this.index.entityNameOf(msgIdx).equals(entity)) {
                    this.prevPos = msgIdx;
                    return ScriptedPlot.this.index.getMessage(msgIdx).getDouble(field);
                }
                msgIdx = ScriptedPlot.this.index.getPreviousMessageOfType(msgType, msgIdx);
            }
            return Double.NaN;
        }
    }
}

