/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.LogUtils;

@PluginDescription(author="jqcorreia", name="Statistics", icon="images/menus/changelog.png")
public class StatisticsPlot
extends JPanel
implements MRAVisualization {
    private static final long serialVersionUID = -2664129262334634012L;
    JTable table;
    TableModel model = new TableModel();

    public StatisticsPlot(MRAPanel panel) {
        this.setLayout((LayoutManager)new MigLayout());
    }

    @Override
    public String getName() {
        return I18n.text("Statistics");
    }

    @Override
    public JComponent getComponent(IMraLogGroup source, double timestep) {
        this.table = new JTable(this.model);
        this.table.setTableHeader(null);
        this.model.map = LogUtils.generateStatistics(source);
        this.add((Component)new JScrollPane(this.table), "w 100%, h 100%");
        return this;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("images/menus/changelog.png");
    }

    @Override
    public Double getDefaultTimeStep() {
        return null;
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return false;
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }

    @Override
    public void onCleanup() {
    }

    class TableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public LinkedHashMap<String, String> map = new LinkedHashMap();

        TableModel() {
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object key = this.map.keySet().toArray()[rowIndex];
            if (columnIndex == 0) {
                return key;
            }
            return this.map.get(key);
        }

        @Override
        public int getRowCount() {
            return this.map.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }
    }
}

