/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Temperature;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.plots.XYPlot;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(active=false)
public class TemperatureVsDepthPlot
extends XYPlot {
    public TemperatureVsDepthPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public String getName() {
        return I18n.text("Temperature VS Depth");
    }

    @Override
    public String getXAxisName() {
        return I18n.text("Depth (meters)");
    }

    @Override
    public String getYAxisName() {
        return I18n.text("Temperature (\u00baC)");
    }

    @Override
    public void process(LsfIndex source) {
        String depthEntity = MRAProperties.depthEntity.toString().replaceAll("_", " ");
        int ctdId = source.getEntityId(depthEntity);
        if (ctdId == 255) {
            MRAProperties.depthEntities e;
            String ent;
            MRAProperties.depthEntities[] arr$ = MRAProperties.depthEntities.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (ctdId = source.getEntityId(ent = (e = arr$[i$]).toString().replaceAll("_", " "))) == 255; ++i$) {
            }
        }
        LsfIterator tempIt = source.getIterator(Temperature.class);
        for (Temperature temp : tempIt) {
            IMCMessage msg;
            if (temp.getSrcEnt() != ctdId || (msg = source.getMessageAt("EstimatedState", temp.getTimestamp())) == null) continue;
            this.addValue(temp.getTimestampMillis(), -msg.getDouble("depth"), temp.getValue(), temp.getSourceName(), "Temperature");
        }
    }

    @Override
    public void addLogMarker(LogMarker marker) {
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"EstimatedState", "Temperature"});
    }
}

