/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import java.util.Date;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.bathymetry.TidePredictionFactory;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;

@PluginDescription(active=false)
public class TidePlot
extends MRATimeSeriesPlot {
    public TidePlot(MRAPanel mp) {
        super(mp);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return TidePredictionFactory.create(index) != null;
    }

    @Override
    public void process(LsfIndex source) {
        TidePredictionFinder finder = TidePredictionFactory.create(source);
        try {
            for (double i = source.getStartTime(); i < source.getEndTime(); i += 60.0) {
                long time = (long)(i * 1000.0);
                this.addValue(time, "Tide height", finder.getTidePrediction(new Date(time), false).floatValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

