/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import javax.swing.ImageIcon;
import pt.lsts.imc.CpuUsage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="CPU Usage (total)", active=false)
public class TotalCpuPlot
extends MRATimeSeriesPlot {
    public TotalCpuPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"CpuUsage"});
    }

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("pt/lsts/neptus/mra/plots/processor.png");
    }

    @Override
    public void process(LsfIndex source) {
        LsfIterator it = source.getIterator(CpuUsage.class);
        while (it.hasNext()) {
            CpuUsage u = (CpuUsage)it.next();
            if (u.getSrcEnt() != 0) continue;
            this.addValue(u.getTimestampMillis(), u.getSourceName() + ".cpu", u.getValue());
        }
    }
}

