/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import javax.swing.ImageIcon;
import pt.lsts.imc.AutopilotMode;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.imc.lsf.LsfIterator;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.PiePlot;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="UAV Mode", author="Jos\u00e9 Braga")
public class UAVModePlot
extends PiePlot {
    public UAVModePlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"AutopilotMode"});
    }

    @Override
    public ImageIcon getIcon() {
        return ImageUtils.getIcon("pt/lsts/neptus/mra/plots/chart-pie.png");
    }

    @Override
    public void process(LsfIndex source) {
        LsfIterator it = source.getIterator(AutopilotMode.class);
        while (it.hasNext()) {
            AutopilotMode u = (AutopilotMode)it.next();
            AutopilotMode.AUTONOMY autonomyLevel = u.getAutonomy();
            this.addValue(this.translate(autonomyLevel), 1.0);
        }
        this.cleanupSeries(0.01);
    }

    private String translate(AutopilotMode.AUTONOMY type) {
        switch (type) {
            case MANUAL: {
                return I18n.text("MANUAL");
            }
            case ASSISTED: {
                return I18n.text("ASSISTED");
            }
            case AUTO: {
                return I18n.text("AUTO");
            }
        }
        return "";
    }
}

