/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import pt.lsts.imc.IMCFieldType;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRAGanttPlot;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription
public class VehicleGanttPlot
extends MRAGanttPlot {
    @Override
    public String getName() {
        return I18n.text("Vehicle Timeline");
    }

    public VehicleGanttPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return true;
    }

    @Override
    public String getVerticalAxisName() {
        return "";
    }

    @Override
    public void process(LsfIndex source) {
        for (IMCMessage s : source.getIterator("VehicleState")) {
            this.startActivity(s.getTimestamp(), I18n.text("Vehicle State"), s.getString("op_mode"));
        }
        this.endActivity(source.getEndTime(), I18n.text("Vehicle State"));
        IMCFieldType type = source.getDefinitions().getType("PlanControlState").getFieldType("man_id");
        String field = type != null ? "man_id" : "node_id";
        for (IMCMessage s : source.getIterator("PlanControlState")) {
            if (s.getString(field) == null || s.getString(field).isEmpty()) continue;
            this.startActivity(s.getTimestamp(), I18n.text("Maneuver"), s.getString(field));
        }
        this.endActivity(source.getEndTime(), I18n.text("Maneuver"));
        for (IMCMessage medium : source.getIterator("VehicleMedium")) {
            this.startActivity(medium.getTimestamp(), I18n.text("Vehicle Medium"), medium.getString("medium"));
        }
        this.endActivity(source.getEndTime(), I18n.text("Vehicle Medium"));
    }
}

