/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRA2DPlot;
import pt.lsts.neptus.mra.plots.TimedXYDataItem;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(active=false)
public class XYPlot
extends MRA2DPlot {
    private LocationType ref;

    public XYPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"EstimatedState"});
    }

    @Override
    public void process(LsfIndex source) {
        double[] offsets;
        LocationType loc;
        IMCMessage estate = source.getMessage(source.getFirstMessageOfType("EstimatedState"));
        this.ref = new LocationType(Math.toDegrees(estate.getDouble("lat")), Math.toDegrees(estate.getDouble("lon")));
        for (IMCMessage state : source.getIterator("EstimatedState", 0, (long)(this.timestep * 1000.0))) {
            loc = new LocationType();
            loc.setLatitudeRads(state.getDouble("lat"));
            loc.setLongitudeRads(state.getDouble("lon"));
            loc.translatePosition(state.getDouble("x"), state.getDouble("y"), state.getDouble("z"));
            offsets = loc.getOffsetFrom(this.ref);
            this.addValue(state.getTimestampMillis(), offsets[0], offsets[1], state.getSourceName(), "position");
        }
        for (IMCMessage state : source.getIterator("SimulatedState", 0, (long)(this.timestep * 1000.0))) {
            loc = new LocationType();
            if (state.getTypeOf("lat") != null) {
                loc.setLatitudeRads(state.getDouble("lat"));
                loc.setLongitudeRads(state.getDouble("lon"));
            } else {
                loc.setLocation(this.ref);
            }
            loc.translatePosition(state.getDouble("x"), state.getDouble("y"), state.getDouble("z"));
            offsets = loc.getOffsetFrom(this.ref);
            this.addValue(state.getTimestampMillis(), offsets[0], offsets[1], state.getSourceName(), "simulator");
        }
    }

    @Override
    public String getName() {
        return I18n.text("XY");
    }

    @Override
    public void addLogMarker(LogMarker marker) {
        XYSeries markerSeries = this.getMarkerSeries();
        IMCMessage state = this.mraPanel.getSource().getLog("EstimatedState").getEntryAtOrAfter(new Double(marker.getTimestamp()).longValue());
        LocationType loc = marker.getLocation();
        this.ref = new LocationType(Math.toDegrees(state.getDouble("lat")), Math.toDegrees(state.getDouble("lon")));
        loc.setLatitudeRads(state.getDouble("lat"));
        loc.setLongitudeRads(state.getDouble("lon"));
        loc.translatePosition(state.getDouble("x"), state.getDouble("y"), state.getDouble("z"));
        double[] offsets = loc.getOffsetFrom(this.ref);
        if (markerSeries != null) {
            markerSeries.add((XYDataItem)new TimedXYDataItem(offsets[0], offsets[1], state.getTimestampMillis(), marker.getLabel()));
        }
    }

    @Override
    public void removeLogMarker(LogMarker marker) {
    }

    @Override
    public void GotoMarker(LogMarker marker) {
    }
}

