/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.plots;

import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRATimeSeriesPlot;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.bathymetry.TidePredictionFactory;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;

@PluginDescription
public class ZPlot
extends MRATimeSeriesPlot {
    public ZPlot(MRAPanel panel) {
        super(panel);
    }

    @Override
    public String getTitle() {
        return "Z plot";
    }

    @Override
    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"EstimatedState"});
    }

    @Override
    public void process(LsfIndex source) {
        TidePredictionFinder tide = TidePredictionFactory.create(source);
        if (source.getDefinitions().getVersion().compareTo("5.0.0") >= 0) {
            for (IMCMessage es : source.getIterator("EstimatedState", 0, (long)(this.timestep * 1000.0))) {
                double depth = es.getDouble("depth");
                double alt = es.getDouble("alt");
                if (depth != -1.0) {
                    this.addValue(es.getTimestampMillis(), es.getSourceName() + "." + I18n.text("Depth"), depth);
                }
                if (alt != -1.0) {
                    this.addValue(es.getTimestampMillis(), es.getSourceName() + "." + I18n.text("Altitude"), alt);
                }
                if (depth == -1.0 || alt == -1.0) continue;
                if (tide == null) {
                    this.addValue(es.getTimestampMillis(), es.getSourceName() + "." + I18n.text("Bathymetry"), Math.max(0.0, depth) + Math.max(0.0, alt));
                    continue;
                }
                double tHeight = 0.0;
                try {
                    tHeight = tide.getTidePrediction(es.getDate(), false).floatValue();
                    this.addValue(es.getTimestampMillis(), I18n.text("Tide Level"), tHeight);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.addValue(es.getTimestampMillis(), es.getSourceName() + "." + I18n.text("Bathymetry"), Math.max(0.0, depth) + Math.max(0.0, alt) - tHeight);
            }
        } else {
            for (IMCMessage es : source.getIterator("depth")) {
                this.addValue(es.getTimestampMillis(), es.getSourceName() + "." + I18n.text("Depth"), es.getDouble("value"));
            }
            int i = source.getFirstMessageOfType("BottomDistance");
            while (i != -1) {
                IMCMessage m = source.getMessage(i);
                String entity = source.getEntityName(m.getSrc(), (int)m.getSrcEnt());
                if (entity.equals("DVL")) {
                    this.addValue(m.getTimestampMillis(), m.getSourceName() + "." + I18n.text("Altitude"), m.getDouble("value"));
                }
                i = source.getNextMessageOfType("BottomDistance", i);
            }
        }
    }

    @Override
    public String getHorizontalAxisName() {
        return I18n.text("meters");
    }

    @Override
    public String getName() {
        return I18n.text("Z");
    }
}

