/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashMap;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(icon="pt/lsts/neptus/mra/replay/lighthouse.png")
public class AnnouncesReplay
implements LogReplayLayer {
    protected LinkedHashMap<String, LocationType> systemsPositions = new LinkedHashMap();
    protected LinkedHashMap<String, Double> lastAnnounces = new LinkedHashMap();
    protected double curTime = 0.0;

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLsfIndex().containsMessagesOfType(new String[]{"Announce"});
    }

    @Override
    public void cleanup() {
    }

    @Override
    public String getName() {
        return "Announces replay";
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"Announce", "EstimatedState"};
    }

    @Override
    public boolean getVisibleByDefault() {
        return false;
    }

    @Override
    public void onMessage(IMCMessage message) {
        if (message.getMgid() == 151) {
            LocationType loc = new LocationType();
            loc.setLatitudeRads(message.getDouble("lat"));
            loc.setLongitudeRads(message.getDouble("lon"));
            this.systemsPositions.put(message.getString("sys_name"), loc);
            this.lastAnnounces.put(message.getString("sys_name"), message.getTimestamp());
        } else {
            this.curTime = message.getTimestamp();
        }
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        for (String name : this.systemsPositions.keySet()) {
            Graphics2D g2 = (Graphics2D)g.create();
            Point2D pt = renderer.getScreenPosition(this.systemsPositions.get(name));
            double lastTime = this.lastAnnounces.get(name);
            if (this.curTime - lastTime > 20.0) {
                g2.setColor(Color.gray);
            } else {
                g2.setColor(Color.orange);
            }
            g2.translate(pt.getX(), pt.getY());
            g2.fill(new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0));
            g2.setColor(Color.black);
            g2.drawString(name, 5, 0);
        }
    }

    @Override
    public void parse(IMraLogGroup source) {
    }
}

