/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Graphics2D;
import java.io.File;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColormapOverlay;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAProperties;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.ImageLayer;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.bathymetry.TidePredictionFactory;
import pt.lsts.neptus.util.bathymetry.TidePredictionFinder;

@LayerPriority(priority=-60)
@PluginDescription(icon="pt/lsts/neptus/mra/replay/color.png")
public class BathymetryReplay
extends ColormapOverlay
implements LogReplayLayer {
    @NeptusProperty(name="Cell width")
    public int cellWidth = 8;
    private LsfIndex index;
    private boolean parsed = false;
    private boolean parsing = false;

    public BathymetryReplay() {
        super("Bathymetry", 50, true, 0);
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLsfIndex().getDefinitions().getVersion().compareTo("5.0.0") >= 0 && source.getLsfIndex().containsMessagesOfType(new String[]{"Distance"});
    }

    @Override
    public void cleanup() {
        this.scaled = null;
        this.generated = null;
    }

    @Override
    public String getName() {
        return I18n.text("Bathymetry layer");
    }

    @Override
    public String[] getObservedMessages() {
        return new String[0];
    }

    @Override
    public boolean getVisibleByDefault() {
        return false;
    }

    @Override
    public void onMessage(IMCMessage message) {
    }

    @Override
    public void parse(IMraLogGroup source) {
        this.index = source.getLsfIndex();
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!this.parsed) {
            ((ColormapOverlay)this).cellWidth = this.cellWidth;
            this.parsed = true;
            this.parsing = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    TidePredictionFinder finder = TidePredictionFactory.create(BathymetryReplay.this.index);
                    if (BathymetryReplay.this.index.getDefinitions().getVersion().compareTo("5.0.0") >= 0) {
                        for (EstimatedState state : BathymetryReplay.this.index.getIterator(EstimatedState.class)) {
                            if (state.getAlt() < 0.0 || state.getDepth() < MRAProperties.minDepthForBathymetry || Math.abs(state.getTheta()) > Math.toDegrees(10.0)) continue;
                            LocationType loc = new LocationType(Math.toDegrees(state.getLat()), Math.toDegrees(state.getLon()));
                            loc.translatePosition(state.getX(), state.getY(), 0.0);
                            if (finder == null) {
                                BathymetryReplay.this.addSample(loc, state.getAlt() + state.getDepth());
                                continue;
                            }
                            try {
                                BathymetryReplay.this.addSample(loc, state.getAlt() + state.getDepth() - (double)finder.getTidePrediction(state.getDate(), false).floatValue());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    BathymetryReplay.this.generated = BathymetryReplay.this.generateImage(ColorMapFactory.createJetColorMap());
                    ImageLayer il = BathymetryReplay.this.getImageLayer();
                    try {
                        il.saveToFile(new File(BathymetryReplay.this.index.getLsfFile().getParentFile(), "mra/dvl.layer"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    BathymetryReplay.this.parsing = false;
                }
            }, "Bathymetry overlay").start();
        }
        if (!this.parsing) {
            super.paint(g, renderer);
        }
    }
}

