/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcId16;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.llf.LogUtils;

@LayerPriority(priority=-10)
@PluginDescription(icon="pt/lsts/neptus/mra/replay/globe.png")
public class EstimatedStateReplay
implements LogReplayLayer {
    protected HashMap<Integer, Vector<LocationType>> positions = new LinkedHashMap<Integer, Vector<LocationType>>();
    protected Vector<Double> timestamps = new Vector();
    protected HashMap<Integer, VehiclePaths> pathsList = new LinkedHashMap<Integer, VehiclePaths>();
    protected int currentPos = 0;
    protected double lastZoom = -1.0;
    protected double lastRotation = 0.0;

    @Override
    public String getName() {
        return I18n.text("EstimatedState path");
    }

    @Override
    public void cleanup() {
        this.positions.clear();
        this.timestamps.clear();
        this.pathsList.clear();
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLog("EstimatedState") != null;
    }

    @Override
    public void parse(IMraLogGroup source) {
        IMCMessage m;
        IMraLog log = source.getLog("EstimatedState");
        while ((m = log.nextLogEntry()) != null) {
            int src = m.getSrc();
            Vector<LocationType> pos = this.positions.get(src);
            if (pos == null) {
                pos = new Vector();
                VehiclePaths paths = new VehiclePaths();
                VehicleType vt = VehiclesHolder.getVehicleWithImc(new ImcId16(src));
                if (vt != null) {
                    paths.setColor(VehiclesHolder.getVehicleWithImc(new ImcId16(src)).getIconColor());
                } else {
                    paths.setColor(new Color(0, 0, 0, 128));
                }
                this.pathsList.put(src, paths);
                this.positions.put(src, pos);
            }
            LocationType loc = LogUtils.getLocation(m);
            loc.convertToAbsoluteLatLonDepth();
            pos.add(loc);
            this.timestamps.add(m.getTimestamp());
            log.advance(500L);
        }
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"EstimatedState"};
    }

    @Override
    public void onMessage(IMCMessage message) {
        double curTime = message.getTimestamp();
        while (this.currentPos < this.timestamps.size() && this.timestamps.get(this.currentPos) < curTime) {
            ++this.currentPos;
        }
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if ((double)renderer.getZoom() != this.lastZoom) {
            for (int i : this.positions.keySet()) {
                VehiclePaths paths = this.pathsList.get(i);
                Point2D pivot = renderer.getScreenPosition(this.positions.get(i).firstElement());
                paths.path1 = new GeneralPath();
                paths.path2 = new GeneralPath();
                paths.path1.moveTo(0.0f, 0.0f);
                paths.path2.moveTo(0.0f, 0.0f);
                for (LocationType loc : this.positions.get(i)) {
                    Point2D pt = renderer.getScreenPosition(loc);
                    double diffX = pt.getX() - pivot.getX();
                    double diffY = pt.getY() - pivot.getY();
                    paths.path1.lineTo(diffX, diffY);
                    paths.path2.moveTo(diffX, diffY);
                    paths.path2.lineTo(diffX, diffY);
                }
            }
            this.lastZoom = renderer.getZoom();
            this.lastRotation = renderer.getRotation();
        }
        for (int i : this.positions.keySet()) {
            Point2D pivot = renderer.getScreenPosition(this.positions.get(i).firstElement());
            VehiclePaths paths = this.pathsList.get(i);
            g.translate(pivot.getX(), pivot.getY());
            g.rotate(-renderer.getRotation() + this.lastRotation);
            g.setColor(paths.color.darker().darker());
            g.draw(paths.path1);
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(paths.color);
            g.draw(paths.path2);
            g.translate(-pivot.getX(), -pivot.getY());
        }
    }

    @Override
    public boolean getVisibleByDefault() {
        return true;
    }

    private class VehiclePaths {
        public GeneralPath path1 = new GeneralPath();
        public GeneralPath path2 = new GeneralPath();
        public Color color;

        private VehiclePaths() {
        }

        public void setColor(Color c) {
            this.color = c;
        }
    }
}

