/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@LayerPriority(priority=-40)
@PluginDescription(icon="pt/lsts/neptus/mra/replay/geolocation.png")
public class GPSFixReplay
implements LogReplayLayer {
    protected LinkedList<LocationType> validFixes = new LinkedList();
    protected LinkedList<LocationType> invalidFixes = new LinkedList();
    protected LinkedHashMap<String, IMCMessage> fixesToPaint = new LinkedHashMap();

    @Override
    public String getName() {
        return I18n.text("GPS Fixes");
    }

    @Override
    public void cleanup() {
        this.validFixes.clear();
        this.invalidFixes.clear();
        this.fixesToPaint.clear();
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLog("GpsFix") != null;
    }

    @Override
    public void parse(IMraLogGroup source) {
        IMCMessage m;
        IMraLog log = source.getLog("GpsFix");
        while ((m = log.nextLogEntry()) != null) {
            double lat;
            double lon = Math.toDegrees(m.getDouble("lon"));
            LinkedHashMap validity = m.getBitmask("validity");
            if (((Boolean)validity.get("VALID_POS")).booleanValue()) {
                this.validFixes.add(new LocationType(lat, lon));
                continue;
            }
            if (lat == 0.0 || lon == 0.0) continue;
            for (lat = Math.toDegrees(m.getDouble("lat")); lat > 90.0; lat -= 90.0) {
            }
            while (lat < 0.0) {
                lat += 90.0;
            }
            while (lon > 180.0) {
                lon -= 180.0;
            }
            while (lon < 0.0) {
                lon += 180.0;
            }
            if (lat == 0.0 || lon == 0.0) continue;
            this.invalidFixes.add(new LocationType(lat, lon));
        }
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"GpsFix"};
    }

    @Override
    public void onMessage(IMCMessage message) {
        this.fixesToPaint.put(message.getSourceName(), message);
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        g.setColor(Color.orange.darker());
        for (LocationType loc : this.validFixes) {
            Point2D pt = renderer.getScreenPosition(loc);
            g.drawLine((int)pt.getX() - 3, (int)pt.getY(), (int)pt.getX() + 3, (int)pt.getY());
            g.drawLine((int)pt.getX(), (int)pt.getY() - 3, (int)pt.getX(), (int)pt.getY() + 3);
        }
        if (this.fixesToPaint.isEmpty()) {
            return;
        }
        Vector<IMCMessage> fixes = new Vector<IMCMessage>();
        fixes.addAll(this.fixesToPaint.values());
        for (IMCMessage fixToPaint : fixes) {
            double lat = Math.toDegrees(fixToPaint.getDouble("lat"));
            double lon = Math.toDegrees(fixToPaint.getDouble("lon"));
            LinkedHashMap validity = fixToPaint.getBitmask("validity");
            LocationType loc = new LocationType(lat, lon);
            if (!((Boolean)validity.get("VALID_POS")).booleanValue()) continue;
            g.setColor(Color.green.darker());
            Point2D pt = renderer.getScreenPosition(loc);
            g.setColor(new Color(255, 0, 25));
            g.setStroke(new BasicStroke(2.0f));
            g.drawLine((int)pt.getX() - 5, (int)pt.getY(), (int)pt.getX() + 5, (int)pt.getY());
            g.drawLine((int)pt.getX(), (int)pt.getY() - 5, (int)pt.getX(), (int)pt.getY() + 5);
            double radius = fixToPaint.getDouble("hacc") * (double)renderer.getZoom();
            Ellipse2D.Double ellis = new Ellipse2D.Double(pt.getX() - radius, pt.getY() - radius, radius * 2.0, radius * 2.0);
            g.setColor(new Color(255, 128, 128, 64));
            g.fill(ellis);
            g.setColor(new Color(255, 128, 25));
            g.draw(ellis);
        }
    }

    @Override
    public boolean getVisibleByDefault() {
        return true;
    }
}

