/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.llf.LsfReportProperties;

@PluginDescription(icon="images/menus/marker.png")
public class LogMarkersReplay
implements LogReplayLayer,
LogMarkerListener {
    ArrayList<LogMarker> markers = new ArrayList();
    Vector<LocationType> locations = new Vector();
    IMraLogGroup source = null;

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Point2D pt = renderer.getScreenPosition(this.locations.get(i));
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(this.markers.get(i).getLabel(), g);
            g.setColor(new Color(255, 255, 255, 128));
            RoundRectangle2D.Double r = new RoundRectangle2D.Double(pt.getX() - 1.0, pt.getY() - 21.0, bounds.getWidth() + 2.0, bounds.getHeight() + 2.0, 5.0, 5.0);
            GeneralPath gp = new GeneralPath();
            gp.moveTo(pt.getX(), pt.getY());
            gp.lineTo(pt.getX(), pt.getY() - 15.0);
            gp.lineTo(pt.getX() + 10.0, pt.getY() - 15.0);
            gp.lineTo(pt.getX(), pt.getY());
            gp.closePath();
            Area a = new Area(gp);
            a.add(new Area(r));
            g.fill(a);
            g.setColor(Color.black);
            g.drawString(this.markers.get(i).getLabel(), (int)(pt.getX() + 1.0), (int)(pt.getY() - 8.0));
        }
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return true;
    }

    @Override
    public String getName() {
        return I18n.text("Log markers layer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMarker(LogMarker m) {
        ArrayList<LogMarker> arrayList = this.markers;
        synchronized (arrayList) {
            if (!this.markers.contains(m)) {
                this.markers.add(m);
                this.locations.add(m.getLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMarker(LogMarker m) {
        if (LsfReportProperties.generatingReport) {
            return;
        }
        ArrayList<LogMarker> arrayList = this.markers;
        synchronized (arrayList) {
            int ind = this.markers.indexOf(m);
            if (ind != -1) {
                this.markers.remove(m);
                this.locations.remove(ind);
            }
        }
    }

    @Override
    public void addLogMarker(LogMarker marker) {
        this.addMarker(marker);
    }

    @Override
    public void removeLogMarker(LogMarker marker) {
        this.removeMarker(marker);
    }

    @Override
    public void GotoMarker(LogMarker marker) {
    }

    @Override
    public void parse(IMraLogGroup source) {
        Collection<LogMarker> sourceMarkers = LogMarker.load(source);
        for (LogMarker lm : sourceMarkers) {
            this.addMarker(lm);
        }
        this.source = source;
    }

    @Override
    public String[] getObservedMessages() {
        return null;
    }

    @Override
    public void onMessage(IMCMessage message) {
    }

    @Override
    public boolean getVisibleByDefault() {
        return true;
    }

    @Override
    public void cleanup() {
    }
}

