/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.console.plugins.MissionChangeListener;
import pt.lsts.neptus.gui.ToolbarSwitch;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.LogMarker;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.plots.LogMarkerListener;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.mra.replay.LogReplayPanel;
import pt.lsts.neptus.mra.replay.MRALogReplayTimeline;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.PluginsRepository;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.llf.LogUtils;

@PluginDescription(name="Mission Replay", icon="pt/lsts/neptus/mra/replay/replay.png")
public class MRALogReplay
extends SimpleMRAVisualization
implements LogMarkerListener,
MissionChangeListener {
    private static final long serialVersionUID = 1L;
    private LsfIndex index;
    private IMraLogGroup source;
    private final Vector<LogReplayLayer> layers = new Vector();
    private final Vector<LogReplayPanel> panels = new Vector();
    private final AsyncEventBus replayBus = new AsyncEventBus("Replay Event bus", (Executor)Executors.newFixedThreadPool(2));
    private StateRenderer2D r2d;
    private JToolBar layersToolbar;
    private MRALogReplayTimeline timeline;
    private final LinkedHashMap<String, Vector<LogReplayComponent>> observers = new LinkedHashMap();
    private final LinkedHashMap<LogReplayPanel, JDialog> popups = new LinkedHashMap();
    private final MRAPanel panel;

    public MRALogReplay(MRAPanel panel) {
        super(panel);
        this.panel = panel;
    }

    @Override
    public void onShow() {
        super.onShow();
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        this.source = source;
        return true;
    }

    @Subscribe
    public synchronized void on(IMCMessage m) {
        try {
            if (this.observers.containsKey(m.getAbbrev())) {
                for (LogReplayComponent c : this.observers.get(m.getAbbrev())) {
                    try {
                        c.onMessage(m);
                    }
                    catch (Exception e) {
                        NeptusLog.pub().error((Object)("Error occured while sending replayed message '" + m.getAbbrev() + "' to component '" + c.getName() + "'"));
                    }
                }
                this.r2d.repaint();
            }
            if (m.getAbbrev().equals("EstimatedState")) {
                SystemPositionAndAttitude state = IMCUtils.parseState(m);
                this.r2d.vehicleStateChanged(m.getSourceName(), state);
                this.r2d.repaint();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bootstrapComponent(LogReplayComponent comp) {
        comp.parse(this.source);
        this.replayBus.register((Object)comp);
        String[] msgs = comp.getObservedMessages();
        if (msgs != null) {
            for (String m : msgs) {
                if (!this.observers.containsKey(m)) {
                    this.observers.put(m, new Vector());
                }
                this.observers.get(m).add(comp);
            }
        }
    }

    private void bootstrap(final LogReplayLayer l) {
        this.bootstrapComponent(l);
        if (l.getVisibleByDefault()) {
            this.r2d.addPostRenderPainter(l, l.getName());
        }
        ToolbarSwitch ts = new ToolbarSwitch(ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(l.getClass()), 16, 16), l.getName(), l.getName());
        ts.setSelected(l.getVisibleByDefault());
        ts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((ToolbarSwitch)e.getSource()).isSelected()) {
                    MRALogReplay.this.r2d.addPostRenderPainter(l, l.getName());
                } else {
                    MRALogReplay.this.r2d.removePostRenderPainter(l);
                }
                MRALogReplay.this.r2d.repaint();
            }
        });
        if (l.getVisibleByDefault()) {
            this.layersToolbar.add((Component)ts, 0);
        } else {
            this.layersToolbar.add((Component)ts, this.layersToolbar.getComponentCount());
        }
        this.layersToolbar.invalidate();
        this.layersToolbar.validate();
    }

    private JDialog getPopup(final LogReplayPanel p) {
        if (this.popups.containsKey(p)) {
            return this.popups.get(p);
        }
        JDialog d = new JDialog(SwingUtilities.getWindowAncestor(this.panel));
        d.setTitle(p.getName());
        d.getContentPane().add(p.getComponent());
        d.pack();
        GuiUtils.centerOnScreen(d);
        d.setDefaultCloseOperation(2);
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                MRALogReplay.this.popups.remove(p);
            }
        });
        this.popups.put(p, d);
        d.setVisible(true);
        return d;
    }

    private void bootstrapPanel(final LogReplayPanel p) {
        this.bootstrapComponent(p);
        ToolbarSwitch ts = new ToolbarSwitch(ImageUtils.getScaledIcon(PluginUtils.getPluginIcon(p.getClass()), 16, 16), p.getName(), p.getName());
        ts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final ToolbarSwitch ts = (ToolbarSwitch)e.getSource();
                if (ts.isSelected()) {
                    JDialog d = MRALogReplay.this.getPopup(p);
                    d.setVisible(true);
                    d.toFront();
                    d.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            ts.setSelected(false);
                        }
                    });
                } else {
                    MRALogReplay.this.getPopup(p).setVisible(false);
                    MRALogReplay.this.getPopup(p).dispose();
                }
            }
        });
        if (p.getVisibleByDefault()) {
            this.layersToolbar.add((Component)ts, 0);
        } else {
            this.layersToolbar.add((Component)ts, this.layersToolbar.getComponentCount());
        }
        this.layersToolbar.invalidate();
        this.layersToolbar.validate();
        if (p.getVisibleByDefault()) {
            ts.doClick();
        }
    }

    @Override
    public JComponent getVisualization(final IMraLogGroup source, double timestep) {
        this.source = source;
        this.index = source.getLsfIndex();
        this.replayBus.register((Object)this);
        this.r2d = new StateRenderer2D();
        this.layersToolbar = new JToolBar("Layers", 1);
        for (Map.Entry<String, Class<? extends LogReplayLayer>> entry : PluginsRepository.getReplayLayers().entrySet()) {
            try {
                LogReplayLayer layer = PluginsRepository.getPlugin(entry.getKey(), LogReplayLayer.class, new Object[0]);
                this.layers.add(layer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry<String, Class<LogReplayComponent>> entry : PluginsRepository.listExtensions(LogReplayPanel.class).entrySet()) {
            try {
                LogReplayPanel p = PluginsRepository.getPlugin(entry.getKey(), LogReplayPanel.class, new Object[0]);
                this.panels.add(p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.timeline = new MRALogReplayTimeline(this);
        if (this.index.containsMessagesOfType(new String[]{"EstimatedState"})) {
            this.r2d.setCenter(IMCUtils.getLocation((IMCMessage)this.index.getFirst(EstimatedState.class)));
        }
        Thread t = new Thread("Starting replay"){

            @Override
            public void run() {
                MissionType mt = LogUtils.generateMission(source);
                MRALogReplay.this.r2d.setMapGroup(MapGroup.getMapGroupInstance(mt));
                ExecutorService executorService = Executors.newCachedThreadPool();
                for (final LogReplayLayer l : MRALogReplay.this.layers) {
                    try {
                        if (!l.canBeApplied(source, LogReplayComponent.Context.MRA)) continue;
                        executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                MRALogReplay.this.bootstrap(l);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (final LogReplayPanel p : MRALogReplay.this.panels) {
                    try {
                        if (!p.canBeApplied(source, LogReplayComponent.Context.MRA)) continue;
                        executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                MRALogReplay.this.bootstrapPanel(p);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        t.setDaemon(true);
        t.start();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.r2d, "Center");
        jPanel.add((Component)this.layersToolbar, "West");
        jPanel.add((Component)this.timeline, "North");
        return jPanel;
    }

    @Override
    public void addLogMarker(LogMarker marker) {
        for (LogReplayLayer l : this.layers) {
            if (!(l instanceof LogMarkerListener)) continue;
            ((LogMarkerListener)((Object)l)).addLogMarker(marker);
        }
    }

    @Override
    public void removeLogMarker(LogMarker marker) {
        for (LogReplayLayer l : this.layers) {
            if (!(l instanceof LogMarkerListener)) continue;
            ((LogMarkerListener)((Object)l)).removeLogMarker(marker);
        }
    }

    @Override
    public void GotoMarker(LogMarker marker) {
        for (LogReplayLayer l : this.layers) {
            if (!(l instanceof LogMarkerListener)) continue;
            ((LogMarkerListener)((Object)l)).GotoMarker(marker);
        }
    }

    @Override
    public void onCleanup() {
        super.onCleanup();
        if (this.timeline != null) {
            this.timeline.cleanup();
        }
        for (JDialog d : this.popups.values()) {
            d.setVisible(false);
            d.dispose();
        }
        for (LogReplayLayer l : this.layers) {
            l.cleanup();
            this.replayBus.unregister((Object)l);
        }
        for (LogReplayPanel p : this.panels) {
            p.cleanup();
            try {
                this.replayBus.unregister((Object)p);
            }
            catch (Exception e) {
                NeptusLog.pub().error((Object)e);
            }
        }
    }

    @Override
    public void missionReplaced(MissionType mission) {
        this.missionUpdated(mission);
    }

    @Override
    public void missionUpdated(MissionType mission) {
        this.r2d.setMapGroup(MapGroup.getMapGroupInstance(mission));
    }

    public LsfIndex getIndex() {
        return this.index;
    }

    @Override
    public void onHide() {
        this.timeline.pause();
        for (JDialog d : this.popups.values()) {
            d.setVisible(false);
            d.dispose();
        }
        this.popups.clear();
    }

    public IMraLogGroup getSource() {
        return this.source;
    }

    public EventBus getReplayBus() {
        return this.replayBus;
    }
}

