/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import com.google.common.eventbus.EventBus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.replay.MRALogReplay;
import pt.lsts.neptus.util.ImageUtils;

public class MRALogReplayTimeline
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 785733887538053098L;
    private JComboBox<String> speedMultiplier = null;
    private JToggleButton play = null;
    private JSlider timeline = null;
    private LsfIndex index;
    private EventBus bus;
    private double timeMultiplier = 1.0;
    private Thread replayThread = null;
    private boolean changing = false;
    private ImageIcon playIcon = ImageUtils.getIcon("pt/lsts/neptus/mra/replay/control-play.png");
    private JLabel time = new JLabel();
    private SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");

    public MRALogReplayTimeline(MRALogReplay replay) {
        this.index = replay.getIndex();
        this.bus = replay.getReplayBus();
        this.sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.time.setText(this.sdf.format(new Date(1000L * (long)this.index.getStartTime())));
        this.setLayout(new BorderLayout());
        JPanel tmp = new JPanel();
        this.play = this.getPlayButton();
        tmp.add(this.play);
        this.speedMultiplier = this.getSpeedCombo();
        tmp.add(this.speedMultiplier, "West");
        this.add((Component)this.getTimeline(replay), "Center");
        this.add((Component)tmp, "West");
        this.add((Component)this.time, "East");
    }

    public void cleanup() {
        if (this.replayThread != null) {
            this.replayThread.interrupt();
        }
    }

    private JSlider getTimeline(MRALogReplay replay) {
        if (this.timeline == null) {
            this.timeline = new JSlider((int)replay.getIndex().getStartTime(), (int)replay.getIndex().getEndTime(), (int)replay.getIndex().getStartTime());
            this.timeline.addChangeListener(this);
            this.timeline.setPaintLabels(true);
            this.timeline.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.timeline;
    }

    public void pause() {
        if (this.getPlayButton().isSelected()) {
            this.getPlayButton().doClick();
        }
    }

    private JToggleButton getPlayButton() {
        if (this.play == null) {
            this.play = new JToggleButton(this.playIcon);
            this.play.setToolTipText(I18n.text("Resume replay"));
            this.play.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MRALogReplayTimeline.this.play.isSelected()) {
                        if (MRALogReplayTimeline.this.replayThread != null) {
                            MRALogReplayTimeline.this.replayThread.interrupt();
                        }
                        MRALogReplayTimeline.this.replayThread = MRALogReplayTimeline.this.createReplayThread();
                        MRALogReplayTimeline.this.replayThread.setDaemon(true);
                        MRALogReplayTimeline.this.replayThread.start();
                        MRALogReplayTimeline.this.play.setToolTipText(I18n.text("Pause replay"));
                    } else {
                        if (MRALogReplayTimeline.this.replayThread != null) {
                            MRALogReplayTimeline.this.replayThread.interrupt();
                        }
                        MRALogReplayTimeline.this.play.setToolTipText(I18n.text("Resume replay"));
                    }
                }
            });
        }
        return this.play;
    }

    private JComboBox<String> getSpeedCombo() {
        if (this.speedMultiplier == null) {
            this.speedMultiplier = new JComboBox<String>(new String[]{"1x", "2x", "5x", "10x", "20x", "60x", "0.5x", "0.25x"});
            this.speedMultiplier.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (MRALogReplayTimeline.this.speedMultiplier.getSelectedItem().toString()) {
                        case "1x": {
                            MRALogReplayTimeline.this.timeMultiplier = 1.0;
                            break;
                        }
                        case "2x": {
                            MRALogReplayTimeline.this.timeMultiplier = 2.0;
                            break;
                        }
                        case "5x": {
                            MRALogReplayTimeline.this.timeMultiplier = 5.0;
                            break;
                        }
                        case "10x": {
                            MRALogReplayTimeline.this.timeMultiplier = 10.0;
                            break;
                        }
                        case "20x": {
                            MRALogReplayTimeline.this.timeMultiplier = 20.0;
                            break;
                        }
                        case "60x": {
                            MRALogReplayTimeline.this.timeMultiplier = 60.0;
                            break;
                        }
                        case "0.5x": {
                            MRALogReplayTimeline.this.timeMultiplier = 0.5;
                            break;
                        }
                        case "0.25x": {
                            MRALogReplayTimeline.this.timeMultiplier = 0.25;
                            break;
                        }
                        default: {
                            MRALogReplayTimeline.this.timeMultiplier = 1.0;
                        }
                    }
                    NeptusLog.pub().info((Object)("Replay speed is now " + MRALogReplayTimeline.this.timeMultiplier + "x realtime"));
                }
            });
        }
        return this.speedMultiplier;
    }

    public void focusTime(double timestamp) {
        if (timestamp < (double)this.timeline.getMinimum()) {
            timestamp = this.timeline.getMinimum();
        }
        if (timestamp > (double)this.timeline.getMaximum()) {
            timestamp = this.timeline.getMaximum();
        }
        this.timeline.setValue((int)timestamp);
        if (this.replayThread != null) {
            this.replayThread.interrupt();
        }
        this.replayThread = this.createReplayThread();
        this.replayThread.start();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.timeline.getValueIsAdjusting()) {
            this.changing = true;
        } else if (this.changing) {
            this.changing = false;
            if (this.play.isSelected()) {
                if (this.replayThread != null) {
                    this.replayThread.interrupt();
                }
                this.replayThread = this.createReplayThread();
                this.replayThread.setDaemon(true);
                this.replayThread.start();
            }
        }
        this.time.setText(this.sdf.format(new Date((long)this.timeline.getValue() * 1000L)));
    }

    private Thread createReplayThread() {
        return new Thread("MRA Log Replay"){

            @Override
            public void run() {
                long lastMissionTime = (long)MRALogReplayTimeline.this.timeline.getValue() * 1000L;
                long lastSystemTime = System.currentTimeMillis();
                int i = MRALogReplayTimeline.this.index.advanceToTime(0, (double)lastMissionTime / 1000.0);
                int k = 0;
                while (!MRALogReplayTimeline.this.timeline.getValueIsAdjusting()) {
                    try {
                        long newTime = System.currentTimeMillis();
                        long ellapsed = newTime - lastSystemTime;
                        lastSystemTime = newTime;
                        long newMissionTime = lastMissionTime + (long)((double)ellapsed * MRALogReplayTimeline.this.timeMultiplier);
                        if (newMissionTime / 1000L != (long)MRALogReplayTimeline.this.timeline.getValue()) {
                            MRALogReplayTimeline.this.timeline.setValue((int)(newMissionTime / 1000L));
                        }
                        int oldI = i;
                        while (!this.isInterrupted() && i < MRALogReplayTimeline.this.index.getNumberOfMessages() && (MRALogReplayTimeline.this.index.timeOf(i) * 1000.0 < (double)newMissionTime || k > 4)) {
                            IMCMessage m = MRALogReplayTimeline.this.index.getMessage(i);
                            MRALogReplayTimeline.this.bus.post((Object)m);
                            ++i;
                            k = 0;
                        }
                        if (i >= MRALogReplayTimeline.this.index.getNumberOfMessages()) {
                            return;
                        }
                        if (oldI == i) {
                            ++k;
                        }
                        lastMissionTime = newMissionTime;
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        return;
                    }
                }
            }
        };
    }
}

