/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.mp.SystemPositionAndAttitude;
import pt.lsts.neptus.mra.api.CorrectedPosition;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.llf.LsfLogSource;

public class MraVehiclePosHud {
    protected LsfIndex index;
    protected Vector<SystemPositionAndAttitude> states = new Vector();
    protected double startTime;
    protected double endTime;
    protected double minX = Double.MAX_VALUE;
    protected double minY = Double.MAX_VALUE;
    protected double maxX = -1.7976931348623157E308;
    protected double maxY = -1.7976931348623157E308;
    protected LocationType ref = null;
    protected BufferedImage map = null;
    protected BufferedImage img = null;
    protected int currentPosition = -1;
    protected int width;
    protected int height;
    protected Color pathColor = Color.black;
    protected IMraLogGroup source;

    public MraVehiclePosHud(IMraLogGroup source, int width, int height) {
        this.source = source;
        this.index = source.getLsfIndex();
        this.width = width;
        this.height = height;
        this.loadIndex();
    }

    public void correctPositions() {
        CorrectedPosition cp = new CorrectedPosition(this.source);
        for (SystemPositionAndAttitude state : this.states) {
            double timestamp = (double)state.getTime() / 1000.0;
            SystemPositionAndAttitude corPos = cp.getPosition(timestamp);
            state.setPosition(new LocationType(corPos.getPosition()));
        }
    }

    protected void loadIndex() {
        this.startTime = Math.ceil(this.index.getStartTime());
        this.endTime = Math.floor(this.index.getEndTime());
        int msgType = this.index.getDefinitions().getMessageId("EstimatedState");
        int lastIndex = 0;
        for (double time = this.startTime; time < this.endTime; time += 1.0) {
            int i = this.index.getMessageAtOrAfer(msgType, 255, lastIndex, time);
            if (i != -1) {
                IMCMessage estimatedState = this.index.getMessage(i);
                LocationType loc = new LocationType(Math.toDegrees(estimatedState.getDouble("lat")), Math.toDegrees(estimatedState.getDouble("lon")));
                loc.setDepth(estimatedState.getDouble("depth"));
                loc.translatePosition(estimatedState.getDouble("x"), estimatedState.getDouble("y"), estimatedState.getDouble("z"));
                if (this.ref == null) {
                    this.ref = new LocationType(loc);
                    loc.convertToAbsoluteLatLonDepth();
                }
                SystemPositionAndAttitude state = new SystemPositionAndAttitude(loc, estimatedState.getDouble("phi"), estimatedState.getDouble("theta"), estimatedState.getDouble("psi"));
                state.setTime(estimatedState.getTimestampMillis());
                this.states.add(state);
                lastIndex = i;
                continue;
            }
            this.states.add(null);
        }
    }

    public BufferedImage getImage(double startTimestamp, double endTimestamp, double timestep) {
        double desiredWidth = this.maxX - this.minX;
        double desiredHeight = this.maxY - this.minY;
        double zoom = (double)(this.width - 20) / desiredWidth;
        zoom = Math.min(zoom, (double)(this.height - 20) / desiredHeight);
        if (this.map == null) {
            this.map = new BufferedImage(this.width, this.height, 2);
            this.createMap();
        }
        this.img = new BufferedImage(this.width, this.height, 2);
        Graphics2D g2 = this.img.createGraphics();
        g2.drawImage((Image)this.map, 0, 0, null);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (double timestamp = startTimestamp; timestamp < endTimestamp; timestamp += timestep) {
            Graphics2D g = (Graphics2D)g2.create();
            this.setTimestamp(timestamp);
            SystemPositionAndAttitude state = this.states.get(this.currentPosition);
            g.scale(zoom, zoom);
            g.translate(-this.minX + 10.0, -this.minY + 10.0);
            double[] offsets = state.getPosition().getOffsetFrom(this.ref);
            g.setColor(Color.red);
            Ellipse2D.Double tmp = new Ellipse2D.Double(offsets[1] - 3.0 / zoom, -offsets[0] - 3.0 / zoom, 6.0 / zoom, 6.0 / zoom);
            g.fill(tmp);
        }
        return this.img;
    }

    public BufferedImage getImage(double timestamp) {
        double desiredWidth = this.maxX - this.minX;
        double desiredHeight = this.maxY - this.minY;
        double zoom = (double)(this.width - 20) / desiredWidth;
        zoom = Math.min(zoom, (double)(this.height - 20) / desiredHeight);
        this.setTimestamp(timestamp);
        SystemPositionAndAttitude state = this.states.get(this.currentPosition);
        if (this.map == null) {
            this.map = new BufferedImage(this.width, this.height, 2);
            this.createMap();
        }
        this.img = new BufferedImage(this.width, this.height, 2);
        Graphics2D g = this.img.createGraphics();
        g.drawImage((Image)this.map, 0, 0, null);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.scale(zoom, zoom);
        g.translate(-this.minX + 10.0, -this.minY + 10.0);
        double[] offsets = state.getPosition().getOffsetFrom(this.ref);
        g.setColor(Color.red);
        Ellipse2D.Double tmp = new Ellipse2D.Double(offsets[1] - 3.0 / zoom, -offsets[0] - 3.0 / zoom, 6.0 / zoom, 6.0 / zoom);
        g.fill(tmp);
        g.setColor(Color.black);
        g.draw(tmp);
        return this.img;
    }

    protected void createMap() {
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 0.0f);
        for (int i = 0; i < this.states.size(); ++i) {
            SystemPositionAndAttitude state = this.states.get(i);
            if (state == null) continue;
            LocationType loc = state.getPosition();
            double[] offsets = loc.getOffsetFrom(this.ref);
            double x = offsets[1];
            double y = -offsets[0];
            this.maxX = Math.max(x, this.maxX);
            this.maxY = Math.max(y, this.maxY);
            this.minX = Math.min(x, this.minX);
            this.minY = Math.min(y, this.minY);
            path.lineTo(x, y);
        }
        double desiredWidth = this.maxX - this.minX;
        double desiredHeight = this.maxY - this.minY;
        double zoom = (double)(this.width - 20) / desiredWidth;
        zoom = Math.min(zoom, (double)(this.height - 20) / desiredHeight);
        Graphics2D g = this.map.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.scale(zoom, zoom);
        g.translate(-this.minX + 10.0, -this.minY + 10.0);
        g.setColor(new Color(this.pathColor.getRed(), this.pathColor.getGreen(), this.pathColor.getBlue(), 64));
        g.setStroke(new BasicStroke(20.0f, 1, 1));
        g.draw(path);
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.setColor(new Color(this.pathColor.getRed(), this.pathColor.getGreen(), this.pathColor.getBlue(), 200));
        g.draw(path);
    }

    public void setTimestamp(double timeSecs) {
        this.currentPosition = timeSecs <= this.startTime ? 0 : (timeSecs >= this.endTime ? this.states.size() - 1 : (int)(timeSecs - this.startTime));
    }

    public double getTimestamp() {
        return (double)this.currentPosition + this.startTime;
    }

    public final double getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public final double getEndTime() {
        return this.endTime;
    }

    public final void setEndTime(double endTime) {
        this.endTime = endTime;
    }

    public final void setPathColor(Color pathColor) {
        if (this.pathColor.getRGB() != pathColor.getRGB()) {
            this.pathColor = pathColor;
            this.map = new BufferedImage(this.width, this.height, 2);
            this.createMap();
        }
    }

    public static void main(String[] args) throws Exception {
        LsfLogSource source = new LsfLogSource(new File("/home/zp/Desktop/REP14/REP_20140708/lauv-noptilus-2/20140708/100908_long_pier/Data.lsf"), null);
        MraVehiclePosHud hud = new MraVehiclePosHud(source, 250, 200);
        hud.correctPositions();
        BufferedImage img = hud.getImage(hud.getStartTime() + 300.0);
        GuiUtils.testFrame(new JLabel(new ImageIcon(img)));
    }
}

