/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.api.BathymetryParser;
import pt.lsts.neptus.mra.api.BathymetryPoint;
import pt.lsts.neptus.mra.api.BathymetrySwath;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.importers.deltat.DeltaTParser;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(name="Multibeam Replay", icon="pt/lsts/neptus/mra/replay/echosounder.png")
public class MultibeamReplay
implements LogReplayLayer {
    private BufferedImage img;
    private Point2D pos;
    private final ColorMap cm = ColorMapFactory.createJetColorMap();
    private BathymetryParser parser;
    private IMraLogGroup source;
    private final int baseLod = 18;
    private static final String MB_IMG_FILE_PATH = "mra/multibeam.png";
    private static final String FILE_83P_EXT = ".83P";
    private boolean isFirstPaint = true;

    @Override
    public void cleanup() {
        this.img = null;
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.isFirstPaint) {
            this.isFirstPaint = false;
            if (this.source.getFile(MB_IMG_FILE_PATH) != null) {
                if (this.img == null) {
                    try {
                        NeptusLog.pub().info((Object)"Loading mra/multibeam.png");
                        this.img = ImageIO.read(this.source.getFile(MB_IMG_FILE_PATH));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.source.getFile(MB_IMG_FILE_PATH) == null) {
                final Graphics2D graph = g;
                final StateRenderer2D rend = renderer;
                Thread t = new Thread(MultibeamReplay.class.getSimpleName() + " " + this.source.getDir().getParent()){

                    @Override
                    public void run() {
                        BathymetrySwath swath;
                        double[] res = ((MultibeamReplay)MultibeamReplay.this).parser.getBathymetryInfo().topLeft.getDistanceInPixelTo(((MultibeamReplay)MultibeamReplay.this).parser.getBathymetryInfo().bottomRight, 18);
                        MultibeamReplay.this.img = new BufferedImage((int)res[0], (int)res[1], 2);
                        MultibeamReplay.this.parser.rewind();
                        while ((swath = MultibeamReplay.this.parser.nextSwath(1.0)) != null) {
                            LocationType loc = swath.getPose().getPosition();
                            for (BathymetryPoint bp : swath.getData()) {
                                LocationType loc2 = new LocationType(loc);
                                if (bp == null) continue;
                                loc2.translatePosition(bp.north, bp.east, 0.0);
                                double[] dist = ((MultibeamReplay)MultibeamReplay.this).parser.getBathymetryInfo().topLeft.getDistanceInPixelTo(loc2, 18);
                                if (!(dist[0] > 0.0) || !(dist[1] > 0.0) || !(dist[0] < (double)MultibeamReplay.this.img.getWidth()) || !(dist[1] < (double)MultibeamReplay.this.img.getHeight())) continue;
                                MultibeamReplay.this.img.setRGB((int)dist[0], (int)dist[1], MultibeamReplay.this.cm.getColor(1.0f - bp.depth / ((MultibeamReplay)MultibeamReplay.this).parser.getBathymetryInfo().maxDepth).getRGB());
                            }
                            MultibeamReplay.this.addImageToRender(graph, rend);
                            graph.dispose();
                            rend.repaint();
                        }
                        try {
                            NeptusLog.pub().info((Object)("Recording " + MultibeamReplay.this.source.getFile("Data.lsf").getParent() + "/" + MultibeamReplay.MB_IMG_FILE_PATH));
                            ImageIO.write((RenderedImage)MultibeamReplay.this.img, "PNG", new File(MultibeamReplay.this.source.getFile("Data.lsf").getParent() + "/" + MultibeamReplay.MB_IMG_FILE_PATH));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        MultibeamReplay.this.addImageToRender(graph, rend);
                    }
                };
                t.setDaemon(true);
                t.start();
            }
            this.addImageToRender(g, renderer);
        } else {
            this.addImageToRender(g, renderer);
        }
    }

    private void addImageToRender(Graphics2D g, StateRenderer2D renderer) {
        this.pos = renderer.getScreenPosition(this.parser.getBathymetryInfo().topLeft);
        int difLod = renderer.getLevelOfDetail() - 18;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.translate(this.pos.getX(), this.pos.getY());
        g2d.rotate(-renderer.getRotation());
        g2d.scale(Math.pow(2.0, difLod), Math.pow(2.0, difLod));
        g2d.drawImage((Image)this.img, 0, 0, null);
        for (int i = 0; i < 200; ++i) {
            double val = (double)(this.parser.getBathymetryInfo().maxDepth * (float)i) / 200.0;
            g.setColor(this.cm.getColor(1.0 - val / (double)this.parser.getBathymetryInfo().maxDepth));
            g.drawRect(10, 100 + i, 10, 1);
            if (i % 50 != 0 && i != 0 && i != 199) continue;
            g.setColor(Color.black);
            g.drawString("" + Math.round(val) + "m", 30, 100 + i);
        }
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        if (source.getLog("EstimatedState") == null) {
            return false;
        }
        boolean canBeApplied = false;
        if (source.getDir().isDirectory()) {
            for (File temp : source.getDir().listFiles()) {
                if (!temp.toString().endsWith(FILE_83P_EXT)) continue;
                canBeApplied = true;
            }
        }
        return canBeApplied;
    }

    @Override
    public String getName() {
        return I18n.text("Multibeam Layer");
    }

    @Override
    public void parse(IMraLogGroup source) {
        this.parser = new DeltaTParser(source);
        this.source = source;
    }

    @Override
    public String[] getObservedMessages() {
        return null;
    }

    @Override
    public void onMessage(IMCMessage message) {
    }

    @Override
    public boolean getVisibleByDefault() {
        return false;
    }
}

