/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import pt.lsts.imc.IMCDefinition;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.transports.ImcUdpTransport;
import pt.lsts.neptus.gui.PropertiesTable;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayPanel;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Network replay", icon="pt/lsts/neptus/mra/replay/network-wireless.png")
public class NetworkReplay
extends JPanel
implements LogReplayPanel {
    private static final long serialVersionUID = -5150861961670234509L;
    private IMCDefinition d;
    private ImcUdpTransport trans = null;
    @NeptusProperty(name="Destination IP", description="IP address of the destination host")
    private String destination = "127.0.0.1";
    @NeptusProperty(name="Destination Port", description="Port of the destination host")
    private int port = 6001;
    @NeptusProperty(name="Local Port")
    private int bindPort = 9199;
    @NeptusProperty(name="Update IMC protocol", description="If selected, all messages will be reencoded to the latest IMC protocol (fields specific to the old protocol will be lost)")
    private boolean updateProtocol = false;
    @NeptusProperty(name="Update timestamps", description="If selected, old messages timestamps will be replaced with current time")
    private boolean updateTimestamps = false;
    @NeptusProperty(name="Post locally (to Neptus)", description="If selected, messages will be received only inside this Neptus instance")
    private boolean postLocally = false;
    private PropertiesTable pt = new PropertiesTable();
    private JToggleButton active;

    @Override
    public String getName() {
        return "Network replay";
    }

    public NetworkReplay() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 250));
        this.pt.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add((Component)this.pt, "Center");
        this.active = new JToggleButton("Active");
        this.active.setSelected(false);
        this.active.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkReplay.this.setActive(NetworkReplay.this.active.isSelected());
            }
        });
        JPanel bottom = new JPanel();
        bottom.add(this.active);
        this.add((Component)bottom, "South");
        this.pt.editProperties(PluginUtils.wrapIntoAPlugInPropertiesProvider(this));
    }

    public void setActive(boolean act) {
        this.pt.setEnabled(!act);
        if (act) {
            try {
                if (this.updateProtocol) {
                    this.trans = new ImcUdpTransport(this.bindPort, IMCDefinition.getInstance());
                }
                this.trans = new ImcUdpTransport(this.bindPort, this.d);
            }
            catch (Exception e) {
                this.trans = null;
                this.pt.setEnabled(true);
                this.active.setSelected(false);
                GuiUtils.errorMessage("Could not start network replay", e.getClass().getSimpleName() + " : " + e.getMessage());
                e.printStackTrace();
                return;
            }
        } else if (this.trans != null) {
            this.trans.stop();
            this.trans = null;
        }
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return true;
    }

    @Override
    public void parse(IMraLogGroup source) {
        this.d = source.getLsfIndex().getDefinitions();
    }

    @Override
    public String[] getObservedMessages() {
        return null;
    }

    @Override
    public void onMessage(IMCMessage message) {
    }

    @Subscribe
    public void on(IMCMessage m) {
        if (this.trans != null) {
            if (this.updateTimestamps) {
                m.setTimestampMillis(System.currentTimeMillis());
            }
            if (this.postLocally) {
                ImcMsgManager.getManager().postInternalMessage(m.getSourceName(), m);
            } else {
                this.trans.sendMessage(this.destination, this.port, m);
            }
        }
    }

    @Override
    public boolean getVisibleByDefault() {
        return false;
    }

    @Override
    public void cleanup() {
        if (this.trans != null) {
            this.trans.stop();
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }
}

