/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Color;
import java.awt.Graphics2D;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.map.MapGroup;
import pt.lsts.neptus.types.map.MapType;
import pt.lsts.neptus.types.map.PlanElement;
import pt.lsts.neptus.types.mission.MissionType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.llf.LogUtils;

@PluginDescription(icon="images/menus/plan.png")
public class PlanReplayLayer
implements LogReplayLayer {
    MissionType mt = null;
    PlanType plan = null;
    PlanElement po = null;

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        this.po.setRenderer(renderer);
        this.po.paint(g, renderer);
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        this.mt = LogUtils.generateMission(source);
        this.plan = LogUtils.generatePlan(this.mt, source);
        return this.plan != null;
    }

    @Override
    public String getName() {
        return "Plan";
    }

    @Override
    public void parse(IMraLogGroup source) {
        this.po = new PlanElement(MapGroup.getMapGroupInstance(this.mt), new MapType());
        this.po.setPlan(this.plan);
        this.po.setColor(new Color(0, 255, 255, 128));
        this.po.setShowDistances(false);
        this.po.setShowManNames(false);
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"PlanControlState"};
    }

    @Override
    public void onMessage(IMCMessage message) {
        this.po.setActiveManeuver(message.getString("man_id"));
    }

    @Override
    public boolean getVisibleByDefault() {
        return false;
    }

    @Override
    public void cleanup() {
    }
}

