/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Graphics2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Salinity;
import pt.lsts.imc.lsf.IndexScanner;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColormapOverlay;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@LayerPriority(priority=-60)
@PluginDescription(name="Salinity Replay", icon="pt/lsts/neptus/mra/replay/waterdrop.png")
public class SalinityReplay
extends ColormapOverlay
implements LogReplayLayer {
    @NeptusProperty(name="Cell width")
    public static int cellWidth = 1;
    private ColorMap cm = ColorMapFactory.createJetColorMap();
    private static final String SALINITY_IMG_FILE_PATH = "mra/salinity.png";
    private boolean isParsed = false;

    public SalinityReplay() {
        super("Salinity", cellWidth, true, 0);
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.isParsed) {
            super.paint(g, renderer);
        }
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLsfIndex().getEntityId("CTD") != 255 && source.getLsfIndex().containsMessagesOfType(new String[]{"Conductivity"});
    }

    @Override
    public String getName() {
        return I18n.text("Salinity Replay");
    }

    @Override
    public void parse(final IMraLogGroup source) {
        Thread t = new Thread(SalinityReplay.class.getSimpleName() + " " + source.getDir().getParent()){

            @Override
            public void run() {
                Salinity salinity;
                LsfIndex lsfIndex = source.getLsfIndex();
                IndexScanner indexScanner = new IndexScanner(lsfIndex);
                while ((salinity = (Salinity)indexScanner.next(Salinity.class, "CTD")) != null) {
                    EstimatedState state = (EstimatedState)indexScanner.next(EstimatedState.class);
                    LocationType loc = new LocationType(Math.toDegrees(state.getLat()), Math.toDegrees(state.getLon()));
                    loc.translatePosition(state.getX(), state.getY(), 0.0);
                    try {
                        SalinityReplay.this.addSample(loc, salinity.getValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                SalinityReplay.this.generated = SalinityReplay.this.generateImage(SalinityReplay.this.cm);
                if (source.getFile(SalinityReplay.SALINITY_IMG_FILE_PATH) == null) {
                    try {
                        NeptusLog.pub().info((Object)("Recording " + lsfIndex.getLsfFile().getParentFile() + "/" + SalinityReplay.SALINITY_IMG_FILE_PATH));
                        ImageIO.write((RenderedImage)SalinityReplay.this.generated, "PNG", new File(lsfIndex.getLsfFile().getParentFile() + "/" + SalinityReplay.SALINITY_IMG_FILE_PATH));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                SalinityReplay.this.isParsed = true;
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public String[] getObservedMessages() {
        return null;
    }

    @Override
    public void onMessage(IMCMessage message) {
    }

    @Override
    public boolean getVisibleByDefault() {
        return false;
    }

    @Override
    public void cleanup() {
        this.generated = null;
        this.cm = null;
    }
}

