/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class SideScanComposite
implements Composite {
    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new CompositeContext(){

            @Override
            public void dispose() {
            }

            @Override
            public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
                int width = Math.min(src.getWidth(), dstIn.getWidth());
                int height = Math.min(src.getHeight(), dstIn.getHeight());
                int[] srcPixel = new int[4];
                int[] dstPixel = new int[4];
                int[] srcPixels = new int[width];
                int[] dstPixels = new int[width];
                for (int y = 0; y < height; ++y) {
                    src.getDataElements(0, y, width, 1, srcPixels);
                    dstIn.getDataElements(0, y, width, 1, dstPixels);
                    for (int x = 0; x < width; ++x) {
                        int pixel = srcPixels[x];
                        srcPixel[0] = pixel >> 16 & 0xFF;
                        srcPixel[1] = pixel >> 8 & 0xFF;
                        srcPixel[2] = pixel & 0xFF;
                        srcPixel[3] = pixel >> 24 & 0xFF;
                        pixel = dstPixels[x];
                        dstPixel[0] = pixel >> 16 & 0xFF;
                        dstPixel[1] = pixel >> 8 & 0xFF;
                        dstPixel[2] = pixel & 0xFF;
                        dstPixel[3] = pixel >> 24 & 0xFF;
                        if (srcPixel[0] > dstPixel[0]) {
                            System.arraycopy(srcPixel, 0, dstPixel, 0, 4);
                        }
                        dstPixels[x] = (dstPixel[3] << 24) + (dstPixel[0] << 16) + (dstPixel[1] << 8) + dstPixel[2];
                    }
                    dstOut.setDataElements(0, y, width, 1, dstPixels);
                }
            }
        };
    }
}

