/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.SonarData;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.mra.replay.SideScanComposite;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.coord.MapTileUtil;

@PluginDescription(icon="pt/lsts/neptus/mra/replay/echosounder.png")
public class SidescanReplay
implements LogReplayLayer {
    private final List<SidescanData> dataSet = new ArrayList<SidescanData>();
    private float range = 0.0f;
    private BufferedImage image;
    private double imageScaleX;
    private boolean generate = true;
    private int lod;
    private double top = 0.0;
    private double bot = 0.0;
    private double left = 0.0;
    private double right = 0.0;
    private LocationType topleftLT;
    private LocationType botrightLT;
    private LocationType lastCenter = new LocationType();
    private IMraLogGroup source;
    private boolean firstPaint = true;

    @Override
    public void cleanup() {
        this.image = null;
        this.dataSet.clear();
    }

    protected void generateImage(StateRenderer2D renderer) {
        final StateRenderer2D rend = renderer;
        if (this.dataSet.isEmpty()) {
            return;
        }
        double groundResolution = MapTileUtil.groundResolution(this.dataSet.get((int)0).loc.getLatitudeDegs(), renderer.getLevelOfDetail());
        double invGR = 1.0 / groundResolution;
        this.lod = renderer.getLevelOfDetail();
        this.imageScaleX = (double)(this.range * 2.0f) * invGR / 2000.0;
        Point2D p1 = renderer.getScreenPosition(this.topleftLT);
        Point2D p2 = renderer.getScreenPosition(this.botrightLT);
        this.top = p1.getY();
        this.left = p1.getX();
        this.right = p2.getX();
        this.bot = p2.getY();
        this.image = ImageUtils.createCompatibleImage((int)(this.right - this.left), (int)(this.bot - this.top), 2);
        this.lastCenter = renderer.getCenter();
        Thread t = new Thread(SidescanReplay.class.getSimpleName() + " " + this.source.getDir().getParent()){

            @Override
            public void run() {
                Graphics2D g = (Graphics2D)SidescanReplay.this.image.getGraphics();
                g.setColor(null);
                g.setComposite(new SideScanComposite());
                double lod = rend.getLevelOfDetail();
                for (SidescanData ssd : SidescanReplay.this.dataSet) {
                    if (lod != (double)rend.getLevelOfDetail()) {
                        return;
                    }
                    Point2D p = rend.getScreenPosition(ssd.loc);
                    Graphics2D g2 = (Graphics2D)g.create();
                    g2.translate(-SidescanReplay.this.left, -SidescanReplay.this.top);
                    g2.translate(p.getX() - 1000.0 * SidescanReplay.this.imageScaleX, p.getY());
                    g2.rotate(ssd.heading, 1000.0 * SidescanReplay.this.imageScaleX, 0.0);
                    g2.scale(SidescanReplay.this.imageScaleX, 1.0);
                    g2.drawImage((Image)ssd.img, 0, 0, null);
                    g2.dispose();
                    rend.repaint();
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void paint(Graphics2D g, final StateRenderer2D renderer) {
        Object center = renderer.getCenter().getNewAbsoluteLatLonDepth();
        if (this.firstPaint) {
            this.firstPaint = false;
            renderer.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SidescanReplay.this.generateImage(renderer);
                }
            });
        }
        if (renderer.getLevelOfDetail() != this.lod) {
            this.generate = true;
        }
        if (this.generate) {
            this.generateImage(renderer);
            this.generate = false;
        }
        double[] offset = ((LocationType)center).getDistanceInPixelTo(this.lastCenter, renderer.getLevelOfDetail());
        this.left += offset[0];
        this.top += offset[1];
        Graphics2D g2 = (Graphics2D)g.create();
        g2.rotate(-renderer.getRotation(), renderer.getWidth() / 2, renderer.getHeight() / 2);
        g2.drawImage(this.image, null, (int)this.left, (int)this.top);
        g2.dispose();
        this.lastCenter = center;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLog("EstimatedState") != null && source.getLog("SonarData") != null;
    }

    @Override
    public String getName() {
        return I18n.text("Sidescan Replay");
    }

    @Override
    public void parse(IMraLogGroup source) {
        this.source = source;
        IMraLog ssParse = source.getLog("SonarData");
        IMraLog esParse = source.getLog("EstimatedState");
        IMCMessage msgSS = ssParse.firstLogEntry();
        IMCMessage msgES = esParse.getEntryAtOrAfter(msgSS.getTimestampMillis());
        Object prevMsgSS = null;
        LocationType loc = new LocationType();
        double minLat = 180.0;
        double maxLat = -180.0;
        double minLon = 360.0;
        double maxLon = -360.0;
        this.range = msgSS.getFloat("max_range");
        while (msgSS != null) {
            if ((long)msgSS.getInteger("type") == SonarData.TYPE.SIDESCAN.value()) {
                msgES = esParse.getEntryAtOrAfter(msgSS.getTimestampMillis());
                if (msgES == null) {
                    msgSS = ssParse.nextLogEntry();
                    continue;
                }
                loc.setLatitudeDegs(Math.toDegrees(msgES.getDouble("lat")));
                loc.setLongitudeDegs(Math.toDegrees(msgES.getDouble("lon")));
                loc.setOffsetNorth(msgES.getDouble("x"));
                loc.setOffsetEast(msgES.getDouble("y"));
                Object tempLoc = loc.getNewAbsoluteLatLonDepth();
                if (((LocationType)tempLoc).getLatitudeDegs() < minLat) {
                    minLat = ((LocationType)tempLoc).getLatitudeDegs();
                }
                if (((LocationType)tempLoc).getLatitudeDegs() > maxLat) {
                    maxLat = ((LocationType)tempLoc).getLatitudeDegs();
                }
                if (((LocationType)tempLoc).getLongitudeDegs() < minLon) {
                    minLon = ((LocationType)tempLoc).getLongitudeDegs();
                }
                if (((LocationType)tempLoc).getLongitudeDegs() > maxLon) {
                    maxLon = ((LocationType)tempLoc).getLongitudeDegs();
                }
                if (prevMsgSS != null) {
                    byte[] currentRaw = msgSS.getRawData("data");
                    byte[] prevRaw = prevMsgSS.getRawData("data");
                    for (int i = 0; i < currentRaw.length; ++i) {
                        currentRaw[i] = (byte)((prevRaw[i] + currentRaw[i]) / 2);
                    }
                    msgSS.setValue("data", (Object)currentRaw);
                    double len = msgES.getDouble("u") * 0.063;
                    this.dataSet.add(new SidescanData(currentRaw, (LocationType)loc.getNewAbsoluteLatLonDepth(), msgES.getDouble("psi"), msgES.getDouble("alt"), len));
                } else {
                    double len = msgES.getDouble("u") * 0.2;
                    this.dataSet.add(new SidescanData(msgSS.getRawData("data"), (LocationType)loc.getNewAbsoluteLatLonDepth(), msgES.getDouble("psi"), msgES.getDouble("alt"), len));
                }
            }
            msgSS = ssParse.nextLogEntry();
        }
        this.topleftLT = new LocationType(maxLat, minLon);
        this.botrightLT = new LocationType(minLat, maxLon);
        this.topleftLT.setOffsetNorth(this.range);
        this.topleftLT.setOffsetWest(this.range);
        this.botrightLT.setOffsetSouth(this.range);
        this.botrightLT.setOffsetEast(this.range);
        this.topleftLT = this.topleftLT.getNewAbsoluteLatLonDepth();
        this.botrightLT = this.botrightLT.getNewAbsoluteLatLonDepth();
    }

    @Override
    public String[] getObservedMessages() {
        return null;
    }

    @Override
    public void onMessage(IMCMessage message) {
    }

    @Override
    public boolean getVisibleByDefault() {
        return false;
    }

    class SidescanData {
        public double heading;
        public double alongTrackLength;
        public BufferedImage img;
        public LocationType loc;

        public SidescanData(byte[] raw, LocationType loc, double heading, double bottDistance, double alongTdist) {
            this.img = ImageUtils.createCompatibleImage(raw.length, 1, 2);
            double startAngle = 185.0;
            double angleStep = 0.085;
            ColorMap cp = ColorMapFactory.createBronzeColormap();
            for (int i = 0; i < raw.length; ++i) {
                double angle = startAngle + angleStep * (double)i;
                double srange = bottDistance * 20.0 / Math.cos(Math.toRadians(angle));
                double d = Math.sqrt(Math.pow(srange, 2.0) - Math.pow(bottDistance, 2.0));
                int pos = (int)d * (i < 1000 ? -1 : 1);
                if (pos <= -1000 || pos >= 1000) continue;
                this.img.setRGB(i, 0, cp.getColor((double)(raw[i] & 0xFF) / 255.0).getRGB());
            }
            this.loc = loc;
            this.heading = heading;
            this.alongTrackLength = alongTdist;
        }
    }
}

