/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@LayerPriority(priority=100)
@PluginDescription
public class SimulatedStateReplay
implements LogReplayLayer {
    protected Vector<LocationType> positions = new Vector();
    protected Vector<Double> timestamps = new Vector();
    protected int currentPos = 0;
    protected GeneralPath path1 = null;
    protected GeneralPath path2 = null;
    protected double lastZoom = -1.0;
    protected double lastRotation = 0.0;
    protected LocationType navStartup = null;
    protected LocationType pos = null;

    @Override
    public String getName() {
        return I18n.text("SimulatedState path");
    }

    @Override
    public void cleanup() {
        this.positions.clear();
        this.timestamps.clear();
        this.path2 = null;
        this.path1 = null;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return source.getLog("SimulatedState") != null && source.getLog("NavigationStartupPoint") != null;
    }

    @Override
    public void parse(IMraLogGroup source) {
        IMraLog log = source.getLog("NavigationStartupPoint");
        IMCMessage m = log.firstLogEntry();
        this.navStartup = new LocationType();
        this.navStartup.setLatitudeDegs(Math.toDegrees(m.getDouble("lat")));
        this.navStartup.setLongitudeDegs(Math.toDegrees(m.getDouble("lon")));
        this.navStartup.setDepth(m.getDouble("depth"));
        log = source.getLog("SimulatedState");
        while ((m = log.nextLogEntry()) != null) {
            LocationType loc = new LocationType(this.navStartup);
            loc.setOffsetNorth(m.getDouble("x"));
            loc.setOffsetEast(m.getDouble("y"));
            loc.setOffsetDown(m.getDouble("z"));
            loc.convertToAbsoluteLatLonDepth();
            this.positions.add(loc);
            this.timestamps.add(m.getTimestamp());
            log.advance(500L);
        }
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"SimulatedState"};
    }

    @Override
    public void onMessage(IMCMessage message) {
        if (!message.getAbbrev().equals("SimulatedState")) {
            return;
        }
        if (this.navStartup == null) {
            return;
        }
        this.pos = new LocationType(this.navStartup);
        this.pos.setOffsetNorth(message.getDouble("x"));
        this.pos.setOffsetEast(message.getDouble("y"));
        this.pos.setOffsetDown(message.getDouble("z"));
        this.pos.convertToAbsoluteLatLonDepth();
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.pos != null) {
            Point2D pt = renderer.getScreenPosition(this.pos);
            g.setColor(Color.white);
            g.fill(new Ellipse2D.Double(pt.getX() - 5.0, pt.getY() - 5.0, 10.0, 10.0));
            g.setColor(Color.blue.brighter().brighter());
            g.draw(new Ellipse2D.Double(pt.getX() - 5.0, pt.getY() - 5.0, 10.0, 10.0));
        }
        Point2D pivot = renderer.getScreenPosition(this.positions.firstElement());
        if ((double)renderer.getZoom() != this.lastZoom) {
            this.path1 = new GeneralPath();
            this.path2 = new GeneralPath();
            this.path1.moveTo(0.0f, 0.0f);
            this.path2.moveTo(0.0f, 0.0f);
            for (LocationType loc : this.positions) {
                Point2D pt = renderer.getScreenPosition(loc);
                double diffX = pt.getX() - pivot.getX();
                double diffY = pt.getY() - pivot.getY();
                this.path1.lineTo(diffX, diffY);
                this.path2.moveTo(diffX, diffY);
                this.path2.lineTo(diffX, diffY);
                this.path2.lineTo(diffX, diffY);
            }
            this.lastZoom = renderer.getZoom();
            this.lastRotation = renderer.getRotation();
        }
        g.translate(pivot.getX(), pivot.getY());
        g.rotate(-renderer.getRotation() + this.lastRotation);
        g.setColor(Color.gray);
        g.draw(this.path1);
        g.setStroke(new BasicStroke(1.5f));
        g.setColor(Color.blue.darker());
        g.draw(this.path2);
    }

    @Override
    public boolean getVisibleByDefault() {
        return true;
    }
}

