/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Graphics2D;
import java.util.Vector;
import javax.swing.JLabel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;

@LayerPriority(priority=100)
public class TrexReplay
implements LogReplayLayer {
    JLabel label = new JLabel();
    Vector<String> messages = new Vector();
    Vector<Double> timestamps = new Vector();
    protected double currentTime = 0.0;

    @Override
    public String getName() {
        return I18n.text("TREX replay");
    }

    @Override
    public void cleanup() {
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        return false;
    }

    @Override
    public void parse(IMraLogGroup source) {
        IMCMessage m;
        IMraLog log = source.getLog("LogBookEntry");
        while ((m = log.nextLogEntry()) != null) {
            if (m.getSrc() != 65000) continue;
            this.messages.add(m.getString("text"));
            this.timestamps.add(m.getTimestamp());
        }
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"LogBookEntry"};
    }

    @Override
    public void onMessage(IMCMessage message) {
        this.currentTime = message.getTimestamp();
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        int curIndex;
        for (curIndex = 0; curIndex < this.timestamps.size() && !(this.timestamps.get(curIndex) > this.currentTime); ++curIndex) {
        }
        String text = "<html>";
        for (int i = curIndex - 1; i > 0 && i > curIndex - 6; --i) {
            text = text + this.messages.get(i) + "<br/>";
        }
        this.label.setText(text + "</html>");
        this.label.setBounds(0, 0, renderer.getWidth() - 10, 100);
        g.translate(5, renderer.getHeight() - 150);
        this.label.paint(g);
    }

    @Override
    public boolean getVisibleByDefault() {
        return true;
    }
}

