/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.replay;

import java.awt.Graphics2D;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.colormap.ColormapOverlay;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.replay.LogReplayComponent;
import pt.lsts.neptus.mra.replay.LogReplayLayer;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

public abstract class ValueColorMap
extends ColormapOverlay
implements LogReplayLayer {
    @NeptusProperty(name="Cell width")
    public int cellWidth = 20;
    private LsfIndex index;
    private boolean parsed = false;
    private boolean parsing = false;
    private String message;
    private String entity;
    private String field;

    public ValueColorMap(String message, String entity) {
        super(message, 20, false, 0);
        this.entity = entity;
        this.message = message;
        this.field = "value";
    }

    public ValueColorMap(String message, String entity, String field) {
        super(message, 20, false, 0);
        this.entity = entity;
        this.message = message;
        this.field = field;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source, LogReplayComponent.Context context) {
        if (this.entity != null && source.getLsfIndex().getEntityId(this.entity) == -1) {
            return false;
        }
        return source.getLsfIndex().getFirstMessageOfType(this.message) != -1;
    }

    @Override
    public void cleanup() {
        this.scaled = null;
        this.generated = null;
    }

    @Override
    public String getName() {
        return this.message + "." + this.field;
    }

    @Override
    public String[] getObservedMessages() {
        return new String[0];
    }

    @Override
    public boolean getVisibleByDefault() {
        return false;
    }

    @Override
    public void onMessage(IMCMessage message) {
    }

    @Override
    public void parse(IMraLogGroup source) {
        this.index = source.getLsfIndex();
    }

    @Override
    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!this.parsed) {
            ((ColormapOverlay)this).cellWidth = this.cellWidth;
            this.parsed = true;
            this.parsing = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    short eid = 255;
                    if (ValueColorMap.this.entity != null) {
                        eid = ValueColorMap.this.index.getEntityId(ValueColorMap.this.entity);
                    }
                    int lastStateIndex = 0;
                    int stateId = ValueColorMap.this.index.getDefinitions().getMessageId("EstimatedState");
                    if (ValueColorMap.this.index.getDefinitions().getVersion().compareTo("5.0.0") >= 0) {
                        for (IMCMessage m : ValueColorMap.this.index.getIterator(ValueColorMap.this.message, 0)) {
                            int state;
                            if (eid != 255 && m.getSrcEnt() != eid || (state = ValueColorMap.this.index.getMessageAtOrAfer(stateId, 255, lastStateIndex, m.getTimestamp())) == -1) continue;
                            lastStateIndex = state;
                            IMCMessage mstate = ValueColorMap.this.index.getMessage(state);
                            LocationType loc = new LocationType(Math.toDegrees(mstate.getDouble("lat")), Math.toDegrees(mstate.getDouble("lon")));
                            loc.translatePosition(mstate.getDouble("x"), mstate.getDouble("y"), 0.0);
                            ValueColorMap.this.addSample(loc, m.getDouble(ValueColorMap.this.field));
                        }
                    }
                    ValueColorMap.this.parsing = false;
                }
            }, "Value overlay").start();
        }
        if (!this.parsing) {
            super.paint(g, renderer);
        }
    }
}

