/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.visualizations;

import com.lowagie.text.Document;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import foxtrot.AsyncTask;
import foxtrot.AsyncWorker;
import foxtrot.Task;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.colormap.ColorBar;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.ColorMapUtils;
import pt.lsts.neptus.colormap.DataDiscretizer;
import pt.lsts.neptus.gui.ColorMapListRenderer;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLog;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

public class ColorMapVisualization
extends JPanel
implements MRAVisualization,
ActionListener {
    public static final int CONDUCTIVITY = 0;
    public static final int TEMPERATURE = 1;
    public static final int SALINITY = 2;
    public static final int BATHYMETRY = 3;
    private IMraLogGroup logSource;
    private int defaultWidth = 800;
    private int defaultHeight = 600;
    private JLabel image = new JLabel();
    private JComboBox<?> cmapCombo = new JComboBox<ColorMap>(ColorMap.cmaps);
    private JComboBox<String> entCombo = new JComboBox();
    private JToolBar toolbar = new JToolBar(0);
    private JTextField cmapMinValue = new JTextField();
    private JTextField cmapMaxValue = new JTextField();
    private JPanel container = new JPanel((LayoutManager)new MigLayout());
    private JButton redrawButton = new JButton("Redraw");
    private JButton savePng = new JButton(new AbstractAction("Save PNG"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorMapVisualization.this.savePNG();
        }
    });
    private JButton savePdf = new JButton(new AbstractAction("Save PDF"){

        @Override
        public void actionPerformed(ActionEvent e) {
            ColorMapVisualization.this.savePDF();
        }
    });
    private DataDiscretizer dd = null;
    private DataDiscretizer.DataPoint[] dps;
    private double scaleY;
    private double scaleX;
    private Vector<String> entityList = new Vector();
    BufferedImage bufImage;
    String messageName;
    String varName;
    String curEntity = "ALL";
    boolean started = false;

    public ColorMapVisualization(MRAPanel panel, String defaultEntity, String fieldToPlot) {
        this.logSource = panel.getSource();
        this.curEntity = defaultEntity;
        this.setLayout((LayoutManager)new MigLayout());
        String[] part = fieldToPlot.split("\\.");
        this.messageName = part[0];
        this.varName = part[1];
        this.entityList.add("ALL");
        this.redrawButton.addActionListener(this);
        this.entCombo.setModel(new DefaultComboBoxModel<String>(this.entityList));
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(this.cmapMinValue);
        this.toolbar.add(this.cmapMaxValue);
        this.toolbar.add(this.cmapCombo);
        this.toolbar.add(this.entCombo);
        this.toolbar.add(this.redrawButton);
        this.toolbar.add(this.savePng);
        this.toolbar.add(this.savePdf);
        this.add((Component)this.toolbar, "w 100%, wrap");
        this.add((Component)this.container, "w 100%, h 100%");
        this.cmapCombo.setSelectedItem(ColorMapFactory.createJetColorMap());
        this.cmapCombo.setRenderer(new ColorMapListRenderer());
        this.revalidate();
    }

    public void redraw(final boolean parseNeeded, final String entityName) {
        AsyncTask task = new AsyncTask(){

            public Object run() throws Exception {
                try {
                    if (parseNeeded) {
                        ColorMapVisualization.this.dd = ColorMapVisualization.this.parseLog(entityName);
                        ColorMapVisualization.access$402(ColorMapVisualization.this, ColorMapVisualization.this.dd.getDataPoints());
                    }
                    ColorMapVisualization.this.bufImage = ColorMapVisualization.this.buildColorMap(0);
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            public void finish() {
                try {
                    this.getResultOrThrow();
                    ColorMapVisualization.this.image.setIcon(new ImageIcon(ColorMapVisualization.this.bufImage));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ColorMapVisualization.this.image.setText("Error creating colormap: " + e.getMessage());
                }
                ColorMapVisualization.this.container.removeAll();
                ColorMapVisualization.this.container.add((Component)new JScrollPane(ColorMapVisualization.this.image), "w 100%, h 100%");
                ColorMapVisualization.this.revalidate();
            }
        };
        AsyncWorker.getWorkerThread().postTask((Task)task);
    }

    private void savePDF() {
        File f = new File(this.logSource.getFile(".") + "/" + this.logSource.name() + "-" + this.messageName + "." + this.varName + "." + this.curEntity + "-" + this.cmapCombo.getSelectedItem().toString() + ".pdf");
        Rectangle pageSize = PageSize.A4.rotate();
        try {
            FileOutputStream out = new FileOutputStream(f);
            Document doc = new Document(pageSize);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            doc.open();
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D g2 = cb.createGraphicsShapes(pageSize.getWidth(), pageSize.getHeight());
            int width = (int)pageSize.getWidth();
            int height = (int)pageSize.getHeight();
            int prevWidth = this.defaultWidth;
            int prevHeight = this.defaultHeight;
            this.defaultWidth = width;
            this.defaultHeight = height;
            BufferedImage img = this.bufImage;
            Image pdfImage = Image.getInstance((PdfWriter)writer, (java.awt.Image)img, (float)0.8f);
            pdfImage.setAbsolutePosition(0.0f, 0.0f);
            cb.addImage(pdfImage);
            double maxX = this.dd.maxX + 5.0;
            double maxY = this.dd.maxY + 5.0;
            double minX = this.dd.minX - 5.0;
            double minY = this.dd.minY - 5.0;
            double dx = maxX - minX;
            double dy = maxY - minY;
            double ratio1 = (double)this.defaultWidth / (double)this.defaultHeight;
            double ratio2 = dx / dy;
            if (ratio2 < ratio1) {
                dx = dy * ratio1;
            } else {
                dy = dx / ratio1;
            }
            this.drawLegend(g2, (ColorMap)this.cmapCombo.getSelectedItem(), 0);
            doc.close();
            this.defaultWidth = prevWidth;
            this.defaultHeight = prevHeight;
            JOptionPane.showMessageDialog(this, "PDF saved to log directory");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void savePNG() {
        int prevWidth = this.defaultWidth;
        int prevHeight = this.defaultHeight;
        this.defaultWidth = 1024;
        this.defaultHeight = 768;
        BufferedImage img = this.bufImage;
        File f = new File(this.logSource.getFile(".") + "/" + this.logSource.name() + "-" + this.messageName + "." + this.varName + "." + this.curEntity + "-" + this.cmapCombo.getSelectedItem().toString() + ".png");
        try {
            ImageIO.write((RenderedImage)img, "png", f);
            JOptionPane.showMessageDialog(this, "PNG saved to log directory");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.defaultWidth = prevWidth;
        this.defaultHeight = prevHeight;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (((String)this.entCombo.getSelectedItem()).equals(this.curEntity)) {
            this.redraw(false, "");
        } else {
            this.curEntity = (String)this.entCombo.getSelectedItem();
            this.redraw(true, this.curEntity);
        }
    }

    private void drawPath(Graphics2D g, double scaleX, double scaleY, double minX, double minY, double timeStep) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setTransform(new AffineTransform());
        g.setColor(new Color(0, 0, 0, 10));
        IMraLog stateParser = this.logSource.getLog("EstimatedState");
        Point2D.Double lastPt = null;
        IMCMessage stateEntry = stateParser.nextLogEntry();
        LocationType ref = new LocationType(Math.toDegrees(stateEntry.getDouble("lat")), Math.toDegrees(stateEntry.getDouble("lon")));
        while (stateEntry != null) {
            LocationType loc = new LocationType();
            loc.setLatitudeRads(stateEntry.getDouble("lat"));
            loc.setLongitudeRads(stateEntry.getDouble("lon"));
            loc.translatePosition(stateEntry.getDouble("x"), stateEntry.getDouble("y"), stateEntry.getDouble("z"));
            double[] offsets = loc.getOffsetFrom(ref);
            Point2D.Double pt = new Point2D.Double((offsets[1] - minY) * scaleY, (-minX - offsets[0]) * scaleX);
            if (timeStep == 0.0) {
                g.setColor(new Color(0, 0, 0, 20));
            } else {
                g.setColor(Color.black);
            }
            if (lastPt != null && pt != null) {
                g.draw(new Line2D.Double(lastPt, pt));
            }
            lastPt = pt;
            if (timeStep == 0.0) {
                stateEntry = stateParser.nextLogEntry();
                continue;
            }
            stateParser.advance((long)(timeStep * 1000.0));
            stateEntry = stateParser.getCurrentEntry();
        }
    }

    private void drawLegend(Graphics2D g, ColorMap cmap, int var) {
        if (this.dd.maxVal == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setTransform(new AffineTransform());
        g.setColor(new Color(255, 255, 255, 100));
        g.fillRoundRect(10, 10, 100, 170, 10, 10);
        ColorBar cb = new ColorBar(1, cmap);
        cb.setSize(15, 80);
        g.setColor(Color.black);
        Font prev = g.getFont();
        g.setFont(new Font("Helvetica", 1, 14));
        g.setFont(prev);
        g.translate(15, 45);
        cb.paint(g);
        g.translate(-10, -15);
        try {
            g.drawString(GuiUtils.getNeptusDecimalFormat(2).format(this.dd.maxVal[var]), 28, 20);
            g.drawString(GuiUtils.getNeptusDecimalFormat(2).format((this.dd.maxVal[var] + this.dd.minVal[var]) / 2.0), 28, 60);
            g.drawString(GuiUtils.getNeptusDecimalFormat(2).format(this.dd.minVal[var]), 28, 100);
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
            e.printStackTrace();
        }
        g.translate(10, 120);
        g.drawLine(0, -3, 0, 3);
        g.drawLine(0, 0, 90, 0);
        g.drawLine(90, -3, 90, 3);
        g.drawString(GuiUtils.getNeptusDecimalFormat(2).format(90.0 / this.scaleX) + " m", 25, 15);
    }

    private DataDiscretizer parseLog(String entity) {
        DataDiscretizer dd = new DataDiscretizer(10.0);
        IMraLog parser = this.logSource.getLog(this.messageName);
        IMraLog stateParser = this.logSource.getLog("EstimatedState");
        if (parser == null || stateParser == null) {
            return dd;
        }
        IMCMessage entry = parser.nextLogEntry();
        IMCMessage stateEntry = stateParser.nextLogEntry();
        LocationType ref = new LocationType(Math.toDegrees(stateEntry.getDouble("lat")), Math.toDegrees(stateEntry.getDouble("lon")));
        this.entityList.clear();
        this.entityList.add("ALL");
        while (entry != null) {
            parser.advance(1L);
            entry = parser.getCurrentEntry();
            if (entry == null) continue;
            String entName = this.logSource.getEntityName(entry.getSrc(), entry.getSrcEnt());
            if (!this.entityList.contains(entName)) {
                this.entityList.add(entName);
            }
            if (!entity.equalsIgnoreCase("ALL") && !entName.equalsIgnoreCase(entity)) continue;
            stateEntry = stateParser.getEntryAtOrAfter(parser.currentTimeMillis());
            LocationType loc = new LocationType();
            loc.setLatitudeRads(stateEntry.getDouble("lat"));
            loc.setLongitudeRads(stateEntry.getDouble("lon"));
            loc.translatePosition(stateEntry.getDouble("x"), stateEntry.getDouble("y"), stateEntry.getDouble("z"));
            double[] offsets = loc.getOffsetFrom(ref);
            double[] vals = new double[4];
            vals[0] = Double.NaN;
            if (stateEntry == null) continue;
            vals[0] = entry.getDouble(this.varName);
            dd.addPoint(offsets[1], -offsets[0], vals);
        }
        this.entCombo.setModel(new DefaultComboBoxModel<String>(this.entityList));
        return dd;
    }

    public BufferedImage buildColorMap(int var) {
        return this.buildColorMap(var, false);
    }

    private BufferedImage buildColorMap(int var, boolean clean) {
        double maxX = this.dd.maxX + 5.0;
        double minX = this.dd.minX - 5.0;
        double dx = maxX - minX;
        double maxY = this.dd.maxY + 5.0;
        double minY = this.dd.minY - 5.0;
        double dy = maxY - minY;
        double ratio2 = dx / dy;
        double ratio1 = (double)this.defaultWidth / (double)this.defaultHeight;
        if (ratio2 < ratio1) {
            dx = dy * ratio1;
        } else {
            dy = dx / ratio1;
        }
        double cx = (maxX + minX) / 2.0;
        double cy = (maxY + minY) / 2.0;
        Rectangle2D.Double bounds = new Rectangle2D.Double(cx - dx / 2.0, cy - dy / 2.0, dx, dy);
        BufferedImage img = new BufferedImage(this.defaultWidth, this.defaultHeight, 2);
        NeptusLog.pub().info((Object)("<###> " + img));
        try {
            ColorMapUtils.generateInterpolatedColorMap((Rectangle2D)bounds, this.dps, var, img.createGraphics(), (double)img.getWidth(), (double)img.getHeight(), 255, (ColorMap)this.cmapCombo.getSelectedItem(), this.dd.minVal[var] * 0.995, this.dd.maxVal[var] * 1.005);
        }
        catch (NullPointerException e) {
            NeptusLog.pub().info((Object)("<###> " + bounds + "," + this.dps + "," + img + "," + this.cmapCombo));
        }
        this.scaleY = (double)img.getWidth() / ((RectangularShape)bounds).getWidth();
        this.scaleX = (double)img.getHeight() / ((RectangularShape)bounds).getHeight();
        minY = bounds.getMinX();
        minX = bounds.getMinY();
        Graphics2D g = (Graphics2D)img.getGraphics();
        if (!clean) {
            this.drawPath(g, this.scaleX, this.scaleY, minX, minY, 0.0);
            this.drawLegend(g, (ColorMap)this.cmapCombo.getSelectedItem(), var);
        }
        return img;
    }

    @Override
    public Component getComponent(IMraLogGroup source, double timestep) {
        this.redraw(true, this.curEntity);
        return this;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return source.getLog("Conductivity") != null && source.getLog("EstimatedState") != null;
    }

    @Override
    public String getName() {
        return I18n.textf("%1 Colormap", this.messageName + "." + this.varName);
    }

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(ImageUtils.getScaledImage("images/buttons/colormap.png", 16, 16));
    }

    @Override
    public Double getDefaultTimeStep() {
        return null;
    }

    @Override
    public boolean supportsVariableTimeSteps() {
        return false;
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.VISUALIZATION;
    }

    @Override
    public void onCleanup() {
        this.removeAll();
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onShow() {
    }

    static /* synthetic */ DataDiscretizer.DataPoint[] access$402(ColorMapVisualization x0, DataDiscretizer.DataPoint[] x1) {
        x0.dps = x1;
        return x1;
    }
}

