/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mra.visualizations;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.importers.IMraLogGroup;
import pt.lsts.neptus.mra.visualizations.MRAVisualization;
import pt.lsts.neptus.mra.visualizations.SimpleMRAVisualization;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.util.llf.MessageHtmlVisualization;
import pt.lsts.neptus.util.llf.RawMessagesTableModel;

@PluginDescription(icon="pt/lsts/neptus/mra/visualizations/doc-search.png")
public class MraRawMessages
extends SimpleMRAVisualization {
    private static final long serialVersionUID = 1L;
    private JTable table;

    public MraRawMessages(MRAPanel panel) {
        super(panel);
    }

    @Override
    public MRAVisualization.Type getType() {
        return MRAVisualization.Type.TABLE;
    }

    @Override
    public boolean canBeApplied(IMraLogGroup source) {
        return true;
    }

    @Override
    public String getName() {
        return "All Messages";
    }

    @Override
    public JComponent getVisualization(IMraLogGroup source, double timestep) {
        final LsfIndex index = source.getLsfIndex();
        this.table = new JTable(new RawMessagesTableModel(source.getLsfIndex()));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MraRawMessages.this.mraPanel.loadVisualization(new MessageHtmlVisualization(index.getMessage(MraRawMessages.this.table.getSelectedRow())), true);
                }
            }
        });
        return new JScrollPane(this.table);
    }
}

