/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.mystate;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.types.coord.CoordinateSystem;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.FileUtil;

public class MyState {
    private static String myStatePath = "./conf/mystate.xml";
    private static final MyState instance = MyState.loadFromXmlFile(myStatePath);
    @XmlElement
    private CoordinateSystem location = new CoordinateSystem();
    @XmlElement
    private double length = 0.0;
    @XmlElement
    private double width = 0.0;
    private long lastLocationUpdateTimeMillis = -1L;

    public static LocationType getLocation() {
        return new LocationType(MyState.instance.location);
    }

    public static long getLastLocationUpdateTimeMillis() {
        return MyState.instance.lastLocationUpdateTimeMillis;
    }

    public static void setLocation(LocationType location) {
        MyState.instance.location.setLocation(location);
        MyState.instance.lastLocationUpdateTimeMillis = System.currentTimeMillis();
        instance.saveXml();
    }

    public static void setLocationAndAxis(LocationType location, double roll, double pitch, double yaw) {
        MyState.instance.location.setLocation(location);
        MyState.instance.lastLocationUpdateTimeMillis = System.currentTimeMillis();
        MyState.instance.location.setRoll(roll);
        MyState.instance.location.setPitch(pitch);
        MyState.instance.location.setYaw(yaw);
        instance.saveXml();
    }

    public static void setLocationAndAxisRadians(LocationType location, double rollRadians, double pitchRadians, double yawRadians) {
        MyState.instance.location.setLocation(location);
        MyState.instance.lastLocationUpdateTimeMillis = System.currentTimeMillis();
        MyState.instance.location.setRoll(Math.toDegrees(rollRadians));
        MyState.instance.location.setPitch(Math.toDegrees(pitchRadians));
        MyState.instance.location.setYaw(Math.toDegrees(yawRadians));
        instance.saveXml();
    }

    public static void setLocationAndAxis(LocationType location, double yaw) {
        MyState.instance.location.setLocation(location);
        MyState.instance.lastLocationUpdateTimeMillis = System.currentTimeMillis();
        MyState.instance.location.setRoll(0.0);
        MyState.instance.location.setPitch(0.0);
        MyState.instance.location.setYaw(yaw);
        instance.saveXml();
    }

    public static void setLocationAndAxisRadians(LocationType location, double yawRadians) {
        MyState.instance.location.setLocation(location);
        MyState.instance.lastLocationUpdateTimeMillis = System.currentTimeMillis();
        MyState.instance.location.setRoll(0.0);
        MyState.instance.location.setPitch(0.0);
        MyState.instance.location.setYaw(Math.toDegrees(yawRadians));
        instance.saveXml();
    }

    public static double[] getAxisAnglesDegrees() {
        return new double[]{MyState.instance.location.getRoll(), MyState.instance.location.getPitch(), MyState.instance.location.getYaw()};
    }

    public static double[] getAxisAnglesRadians() {
        return new double[]{Math.toRadians(MyState.instance.location.getRoll()), Math.toRadians(MyState.instance.location.getPitch()), Math.toRadians(MyState.instance.location.getYaw())};
    }

    public static double getHeadingInRadians() {
        return Math.toRadians(MyState.instance.location.getYaw());
    }

    public static void setHeadingInRadians(double yawRadians) {
        MyState.instance.location.setYaw(Math.toDegrees(yawRadians));
        instance.saveXml();
    }

    public static double getHeadingInDegrees() {
        return MyState.instance.location.getYaw();
    }

    public static void setHeadingInDegrees(double yawDegrees) {
        MyState.instance.location.setYaw(yawDegrees);
        instance.saveXml();
    }

    public static double getLength() {
        return MyState.instance.length;
    }

    public static void setLength(double length) {
        MyState.instance.length = length < 0.0 ? 0.0 : length;
        instance.saveXml();
    }

    public static double getWidth() {
        return MyState.instance.width;
    }

    public static void setWidth(double width) {
        MyState.instance.width = width < 0.0 ? 0.0 : width;
        instance.saveXml();
    }

    private String asXml() {
        StringWriter writer = new StringWriter();
        JAXB.marshal((Object)this, (Writer)writer);
        return writer.toString();
    }

    private static MyState loadXml(String xml) {
        MyState ms = (MyState)JAXB.unmarshal((Reader)new StringReader(xml), MyState.class);
        return ms;
    }

    private static MyState loadFromXmlFile(String myStatePath) {
        File msfx = new File(myStatePath);
        if (msfx.exists()) {
            try {
                return MyState.loadXml(FileUtil.getFileAsString(msfx));
            }
            catch (Exception e) {
                NeptusLog.pub().warn((Object)"Problem loading MyState from file. Reverting to default.", (Throwable)e);
                return new MyState();
            }
        }
        return new MyState();
    }

    private void saveXml() {
        String ms = this.asXml();
        FileUtil.saveToFile(myStatePath, ms);
    }

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            MyState.setHeadingInDegrees(45.0);
        }
        System.err.println(" " + (System.currentTimeMillis() - start));
    }
}

