/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.params;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.BooleanAsCheckBoxPropertyEditor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.editor.ArrayListEditor;
import pt.lsts.neptus.gui.editor.ComboEditor;
import pt.lsts.neptus.gui.editor.NumberEditor;
import pt.lsts.neptus.gui.editor.StringPatternEditor;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.params.InvalidConfigurationException;
import pt.lsts.neptus.params.SystemProperty;
import pt.lsts.neptus.params.editor.ComboEditorWithDependancy;
import pt.lsts.neptus.params.editor.PropertyEditorChangeValuesIfDependancyAdapter;
import pt.lsts.neptus.params.editor.custom.CustomSystemPropertyEditor;
import pt.lsts.neptus.params.renderer.BooleanSystemPropertyRenderer;
import pt.lsts.neptus.params.renderer.I18nSystemPropertyRenderer;
import pt.lsts.neptus.params.renderer.SystemPropertyRenderer;
import pt.lsts.neptus.util.FileUtil;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class ConfigurationManager {
    public static final String CONF_DIR = "conf/params/";
    private HashMap<String, HashMap<String, SystemProperty>> map = new LinkedHashMap<String, HashMap<String, SystemProperty>>();
    private List<String> sections = new ArrayList<String>();
    private Document doc;
    private static ConfigurationManager instance = null;
    private static boolean loading = false;

    private ConfigurationManager() {
        this.loadConfigurations();
    }

    public static ConfigurationManager getInstance() {
        if (instance == null && !loading) {
            loading = true;
            instance = new ConfigurationManager();
            loading = false;
        }
        long timeS = System.currentTimeMillis();
        while (loading) {
            try {
                Thread.sleep(100L);
                if (System.currentTimeMillis() - timeS <= 3000L) continue;
                timeS = System.currentTimeMillis();
                NeptusLog.pub().warn((Object)"Waiting for parameters to be loaded...");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    private void loadConfigurations() {
        String lang = GeneralPreferences.language;
        File fx = new File(CONF_DIR);
        if (fx.exists()) {
            for (File f : fx.listFiles()) {
                if (!f.isFile()) continue;
                String fname = f.getName();
                String fext = FileUtil.getFileExtension(fname);
                if (!fname.replaceAll("." + fext + "$", "").endsWith(lang)) continue;
                NeptusLog.pub().debug((Object)("Loading vehicle configuration from " + f.getName()));
                String systemName = f.getName().split("\\.")[0];
                try {
                    this.map.put(systemName, this.readConfiguration(f));
                }
                catch (InvalidConfigurationException e) {
                    NeptusLog.pub().error((Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    private String getTagContents(Element root, String name) {
        Element node = (Element)root.selectSingleNode(name);
        if (node == null) {
            return null;
        }
        return node.getStringValue();
    }

    private HashMap<String, SystemProperty> readConfiguration(File file) throws InvalidConfigurationException {
        LinkedHashMap<String, SystemProperty> params = new LinkedHashMap<String, SystemProperty>();
        SAXReader reader = new SAXReader();
        try {
            this.doc = reader.read(file);
        }
        catch (DocumentException e1) {
            e1.printStackTrace();
        }
        params.clear();
        List sectionList = this.doc.selectNodes("//config/*");
        for (Object osection : sectionList) {
            Element section = (Element)osection;
            String sectionName = section.attributeValue("name");
            if (sectionName == null) {
                NeptusLog.pub().error((Object)("Error loading unnamed section for " + file.getName()));
                continue;
            }
            LinkedHashMap<String, SystemProperty> sectionParams = new LinkedHashMap<String, SystemProperty>();
            String sectionI18nName = section.attributeValue("name-i18n");
            if (sectionI18nName == null) {
                sectionI18nName = sectionName;
            }
            this.sections.add(sectionName);
            Node editorNode = section.selectSingleNode("@editor");
            CustomSystemPropertyEditor sectionCustomEditor = null;
            if (editorNode != null) {
                String editorStr = editorNode.getText();
                try {
                    String str = CustomSystemPropertyEditor.class.getPackage().getName() + "." + editorStr + "CustomEditor";
                    Class<?> clazz = Class.forName(str);
                    try {
                        sectionCustomEditor = (CustomSystemPropertyEditor)clazz.getConstructor(Map.class).newInstance(sectionParams);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            for (Object oparam : section.selectNodes("*")) {
                String unitsTxt;
                ArrayList<?> valuesI18n;
                SystemProperty property;
                Class clazz;
                Element param = (Element)oparam;
                String paramName = param.attributeValue("name");
                if (paramName == null) {
                    NeptusLog.pub().error((Object)("Error loading unnamed param for section " + sectionName + " for " + file.getName()));
                    continue;
                }
                String paramI18nName = this.getTagContents(param, "name-i18n");
                String scope = this.getTagContents(param, "scope");
                String visibility = this.getTagContents(param, "visibility");
                String type = this.getTagContents(param, "type");
                String desc = this.getTagContents(param, "desc");
                String units = this.getTagContents(param, "units");
                String defaultValue = this.getTagContents(param, "default");
                Element pValues = (Element)param.selectSingleNode("values");
                List pValuesIfList = param.selectNodes("values-if");
                String minStr = this.getTagContents(param, "min");
                String maxStr = this.getTagContents(param, "max");
                String sizeList = this.getTagContents(param, "size");
                String sizeMinList = this.getTagContents(param, "min-size");
                String sizeMaxList = this.getTagContents(param, "max-size");
                SystemProperty.ValueTypeEnum valueType = SystemProperty.ValueTypeEnum.STRING;
                boolean isList = false;
                if (type.equals(SystemProperty.ValueTypeEnum.BOOLEAN.getText())) {
                    clazz = Boolean.class;
                    valueType = SystemProperty.ValueTypeEnum.BOOLEAN;
                } else if (type.endsWith(SystemProperty.ValueTypeEnum.INTEGER.getText())) {
                    clazz = Long.class;
                    valueType = SystemProperty.ValueTypeEnum.INTEGER;
                    if (type.startsWith("list:")) {
                        clazz = ArrayList.class;
                        isList = true;
                    }
                } else if (type.endsWith(SystemProperty.ValueTypeEnum.REAL.getText())) {
                    clazz = Double.class;
                    valueType = SystemProperty.ValueTypeEnum.REAL;
                    if (type.startsWith("list:")) {
                        clazz = ArrayList.class;
                        isList = true;
                    }
                } else if (type.equals("list:" + SystemProperty.ValueTypeEnum.STRING.getText())) {
                    clazz = ArrayList.class;
                    valueType = SystemProperty.ValueTypeEnum.STRING;
                    isList = true;
                } else {
                    clazz = type.startsWith("list:") ? ArrayList.class : String.class;
                    valueType = SystemProperty.ValueTypeEnum.STRING;
                }
                Object value = !isList ? ConfigurationManager.getValueTypedFromString(defaultValue, valueType) : ConfigurationManager.getListValueTypedFromString(defaultValue, valueType);
                Object propEditor = null;
                I18nSystemPropertyRenderer propRenderer = null;
                Double minV = null;
                Double maxV = null;
                String minMaxStr = "";
                if (minStr != null) {
                    try {
                        minV = Double.parseDouble(minStr);
                    }
                    catch (Exception e) {
                        NeptusLog.pub().debug((Object)e.getMessage());
                        minV = null;
                    }
                }
                if (maxStr != null) {
                    try {
                        maxV = Double.parseDouble(maxStr);
                    }
                    catch (Exception e) {
                        NeptusLog.pub().debug((Object)e.getMessage());
                        maxV = null;
                    }
                }
                if (isList) {
                    int size = -1;
                    int minSize = 0;
                    int maxSize = -1;
                    if (sizeList != null) {
                        try {
                            size = Integer.parseInt(sizeList);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        minSize = maxSize = size;
                    } else if (sizeMinList != null || sizeMaxList != null) {
                        if (sizeMinList != null) {
                            try {
                                minSize = Integer.parseInt(sizeMinList);
                            }
                            catch (NumberFormatException e) {
                                NeptusLog.pub().debug((Object)e.getMessage());
                            }
                        }
                        if (sizeMaxList != null) {
                            try {
                                maxSize = Integer.parseInt(sizeMaxList);
                            }
                            catch (NumberFormatException e) {
                                NeptusLog.pub().debug((Object)e.getMessage());
                            }
                        }
                    } else {
                        minSize = maxSize = size;
                    }
                    property = new SystemProperty();
                    switch (valueType) {
                        case INTEGER: {
                            propEditor = minV == null && maxV == null ? ArrayListEditor.forgeLong(minSize, maxSize) : ArrayListEditor.forgeLong(minSize, maxSize, minV == null ? null : Long.valueOf(minV.longValue()), maxV == null ? null : Long.valueOf(maxV.longValue()));
                            minMaxStr = minV == null ? "" : I18n.text("min") + "=" + minV.longValue() + units;
                            String commaSepStr = minMaxStr.length() != 0 ? ", " : "";
                            minMaxStr = minMaxStr + (maxV == null ? "" : commaSepStr + I18n.text("max") + "=" + maxV.longValue() + units);
                            break;
                        }
                        case REAL: {
                            propEditor = minV == null && maxV == null ? ArrayListEditor.forgeDouble(minSize, maxSize) : ArrayListEditor.forgeDouble(minSize, maxSize, minV == null ? null : Double.valueOf(minV), maxV == null ? null : Double.valueOf(maxV));
                            minMaxStr = minV == null ? "" : I18n.text("min") + "=" + minV + units;
                            String commaSepStr = minMaxStr.length() != 0 ? ", " : "";
                            minMaxStr = minMaxStr + (maxV == null ? "" : commaSepStr + I18n.text("max") + "=" + maxV + units);
                            break;
                        }
                        default: {
                            String stringTypeStringNotString = type.replaceAll("^list:", "");
                            if (stringTypeStringNotString.equals(I18n.textmark("ipv4-address"))) {
                                propEditor = ArrayListEditor.forgeString(minSize, maxSize, "(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
                                break;
                            }
                            propEditor = ArrayListEditor.forgeString(minSize, maxSize);
                            break;
                        }
                    }
                } else if (pValues != null) {
                    property = new SystemProperty();
                    String vlStr = pValues.getStringValue();
                    ArrayList<?> values = this.extractStringListToArrayList(type, vlStr);
                    ComboEditor<Object> comboEditor = null;
                    if (values != null) {
                        if (type.equals(SystemProperty.ValueTypeEnum.INTEGER.getText())) {
                            comboEditor = new ComboEditor<Long>(values.toArray(new Long[0]));
                        } else if (type.equals(SystemProperty.ValueTypeEnum.REAL.getText())) {
                            comboEditor = new ComboEditor<Double>(values.toArray(new Double[0]));
                        } else {
                            valuesI18n = this.extractI18nValues(type, pValues, values);
                            comboEditor = new ComboEditor<String>(values.toArray(new String[0]), valuesI18n == null ? null : valuesI18n.toArray(new String[0]));
                            HashMap<String, String> i18nMapper = new HashMap<String, String>();
                            for (int i = 0; i < Math.min(values.size(), valuesI18n.size()); ++i) {
                                Object valObj = values.get(i);
                                Object vaI18nlObj = valuesI18n.get(i);
                                i18nMapper.put(valObj.toString(), vaI18nlObj.toString());
                            }
                            if (i18nMapper.size() > 0) {
                                propRenderer = new I18nSystemPropertyRenderer(i18nMapper);
                            }
                        }
                        propEditor = comboEditor;
                    }
                } else if (pValuesIfList != null) {
                    property = new SystemProperty();
                    ComboEditorWithDependancy<Object> comboEditor = null;
                    PropertyEditorChangeValuesIfDependancyAdapter<Double, Object> pt = type.equals(SystemProperty.ValueTypeEnum.INTEGER.getText()) ? new PropertyEditorChangeValuesIfDependancyAdapter() : (type.equals(SystemProperty.ValueTypeEnum.REAL.getText()) ? new PropertyEditorChangeValuesIfDependancyAdapter() : new PropertyEditorChangeValuesIfDependancyAdapter());
                    if (pt != null) {
                        HashMap<String, String> i18nMapper = new HashMap<String, String>();
                        for (Object obj : pValuesIfList) {
                            double tv;
                            ArrayList<?> values;
                            Element elem = (Element)obj;
                            Element paramComp = (Element)elem.selectSingleNode("param");
                            Element eqParam = (Element)elem.selectSingleNode("equals");
                            Element valuesParam = (Element)elem.selectSingleNode("values");
                            if (paramComp == null || eqParam == null || valuesParam == null || (values = this.extractStringListToArrayList(type, valuesParam.getTextTrim())) == null) continue;
                            try {
                                tv = Double.parseDouble(eqParam.getTextTrim());
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                                break;
                            }
                            if (type.equals(SystemProperty.ValueTypeEnum.INTEGER.getText())) {
                                pt.addValuesIf(paramComp.getText(), tv, PropertyEditorChangeValuesIfDependancyAdapter.TestOperation.EQUALS, values);
                                continue;
                            }
                            if (type.equals(SystemProperty.ValueTypeEnum.REAL.getText())) {
                                pt.addValuesIf(paramComp.getText(), tv, PropertyEditorChangeValuesIfDependancyAdapter.TestOperation.EQUALS, values);
                                continue;
                            }
                            if (!type.equals(SystemProperty.ValueTypeEnum.STRING.getText())) break;
                            ArrayList<?> valuesI18n2 = this.extractI18nValues(type, valuesParam, values);
                            pt.addValuesIf(paramComp.getText(), tv, PropertyEditorChangeValuesIfDependancyAdapter.TestOperation.EQUALS, values, valuesI18n2 != null ? valuesI18n2 : null);
                            for (int i = 0; i < Math.min(values.size(), valuesI18n2.size()); ++i) {
                                Object valObj = values.get(i);
                                Object vaI18nlObj = valuesI18n2.get(i);
                                i18nMapper.put(valObj.toString(), vaI18nlObj.toString());
                            }
                        }
                        if (i18nMapper.size() > 0) {
                            propRenderer = new I18nSystemPropertyRenderer(i18nMapper);
                        }
                    }
                    ArrayList values = pt.getValuesIfTests().size() > 0 ? pt.getValuesIfTests().get((int)0).values : null;
                    ArrayList<Object> arrayList = valuesI18n = pt.getValuesI18nIfTests().size() > 0 ? pt.getValuesI18nIfTests().get((int)0).values : null;
                    if (values != null) {
                        comboEditor = type.equals(SystemProperty.ValueTypeEnum.INTEGER.getText()) ? new ComboEditorWithDependancy<Long>(values.toArray(new Long[0]), pt) : (type.equals(SystemProperty.ValueTypeEnum.REAL.getText()) ? new ComboEditorWithDependancy<Double>(values.toArray(new Double[0]), pt) : new ComboEditorWithDependancy<String>(values.toArray(new String[0]), valuesI18n == null ? null : valuesI18n.toArray(new String[0]), pt));
                        propEditor = comboEditor;
                    }
                } else {
                    property = new SystemProperty();
                }
                if (propEditor == null) {
                    switch (valueType) {
                        case BOOLEAN: {
                            propEditor = new BooleanAsCheckBoxPropertyEditor();
                            break;
                        }
                        case INTEGER: {
                            propEditor = minV == null && maxV == null ? new NumberEditor<Long>(Long.class) : new NumberEditor<Object>((Class<Object>)Long.class, (minV == null ? null : Long.valueOf(minV.longValue())), (maxV == null ? null : Long.valueOf(maxV.longValue())));
                            minMaxStr = minV == null ? "" : I18n.text("min") + "=" + minV.longValue() + units;
                            String commaSepStr = minMaxStr.length() != 0 ? ", " : "";
                            minMaxStr = minMaxStr + (maxV == null ? "" : commaSepStr + I18n.text("max") + "=" + maxV.longValue() + units);
                            break;
                        }
                        case REAL: {
                            propEditor = minV == null && maxV == null ? new NumberEditor<Double>(Double.class) : new NumberEditor<Object>((Class<Object>)Double.class, (minV == null ? null : Double.valueOf(minV)), (maxV == null ? null : Double.valueOf(maxV)));
                            minMaxStr = minV == null ? "" : I18n.text("min") + "=" + minV + units;
                            String commaSepStr = minMaxStr.length() != 0 ? ", " : "";
                            minMaxStr = minMaxStr + (maxV == null ? "" : commaSepStr + I18n.text("max") + "=" + maxV + units);
                            break;
                        }
                        default: {
                            String stringTypeStringNotString = type;
                            propEditor = stringTypeStringNotString.equals("ipv4-address") ? new StringPatternEditor("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)") : new StringPatternEditor(".*");
                        }
                    }
                }
                property.setValueType(valueType);
                property.setName(paramName);
                property.setDisplayName(paramI18nName);
                if (value != null) {
                    property.setValue(value);
                    property.setDefaultValue(value);
                }
                property.setType(clazz);
                String lstSizeTxt = "";
                if (isList) {
                    lstSizeTxt = "[";
                    if (sizeList != null) {
                        try {
                            int sl = Integer.parseInt(sizeList);
                            lstSizeTxt = lstSizeTxt + sl;
                        }
                        catch (NumberFormatException e) {
                            e.printStackTrace();
                            lstSizeTxt = lstSizeTxt + "*";
                        }
                    } else if (sizeMinList != null && sizeMaxList != null) {
                        double maxS;
                        double minS;
                        try {
                            minS = Double.parseDouble(sizeMinList);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            minS = 0.0;
                        }
                        try {
                            maxS = Double.parseDouble(sizeMaxList);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            maxS = -1.0;
                        }
                        if (minS < 0.0) {
                            minS = 0.0;
                        }
                        if (maxS <= 0.0) {
                            maxS = -1.0;
                        }
                        if (minS > maxS) {
                            minS = 0.0;
                        }
                        lstSizeTxt = lstSizeTxt + ((int)minS == (int)minS ? Integer.valueOf((int)minS) : (int)minS + "," + (int)minS);
                    } else {
                        lstSizeTxt = lstSizeTxt + "*";
                    }
                    lstSizeTxt = lstSizeTxt + "]";
                }
                String string = unitsTxt = units.length() > 0 ? "\n(" + units + ")" : "";
                String typeTxt = type != null ? "\n[" + (type.startsWith("list:") ? I18n.text(type.substring(0, 4)) + ":" + I18n.text(type.substring(5)) : I18n.text(type)) + lstSizeTxt + "]" : "";
                String defaultTxt = defaultValue != null ? "\n[" + I18n.text("default") + "=" + defaultValue + units + "]" : "";
                String minMaxValuesTxt = minMaxStr.length() > 0 ? "[" + minMaxStr + "]" : "";
                property.setShortDescription(desc + unitsTxt + typeTxt + defaultTxt + minMaxValuesTxt);
                property.setCategory(sectionI18nName);
                property.setCategoryId(sectionName);
                property.setScope(SystemProperty.Scope.fromString(scope));
                property.setVisibility(SystemProperty.Visibility.fromString(visibility));
                if (propEditor != null) {
                    property.setEditor((AbstractPropertyEditor)propEditor);
                }
                if (propRenderer != null) {
                    property.setRenderer(propRenderer);
                } else if (valueType == SystemProperty.ValueTypeEnum.BOOLEAN) {
                    property.setRenderer(new BooleanSystemPropertyRenderer());
                } else if (units.length() > 0) {
                    property.setRenderer(new SystemPropertyRenderer(units));
                } else {
                    property.setRenderer(new SystemPropertyRenderer());
                }
                if (sectionCustomEditor != null) {
                    property.setSectionCustomEditor(sectionCustomEditor);
                }
                params.put(sectionName + "." + paramName, property);
                sectionParams.put(paramName, property);
            }
        }
        return params;
    }

    private ArrayList<?> extractI18nValues(String type, Element pValues, ArrayList<?> values) {
        Node nd = pValues.selectSingleNode("following-sibling::*");
        ArrayList<?> valuesI18n = null;
        if (nd != null && "values-i18n".equals(nd.getName())) {
            Element elem = (Element)nd;
            String vlI18nStr = elem.getStringValue();
            valuesI18n = this.extractStringListToArrayList(type, vlI18nStr);
            if (values.size() != valuesI18n.size()) {
                valuesI18n = null;
            }
        }
        return valuesI18n;
    }

    private ArrayList<?> extractStringListToArrayList(String type, String vlStr) {
        ArrayList<Object> values = null;
        for (String st : vlStr.split("( *, *)+")) {
            st = st.trim();
            if (type.equals(SystemProperty.ValueTypeEnum.INTEGER.getText())) {
                if (values == null) {
                    values = new ArrayList<Object>();
                }
                try {
                    String dv;
                    String string = dv = st == null ? null : st.replaceAll("\\.\\d+$", "");
                    long vl = dv != null ? Long.parseLong(dv.contains("x") ? dv.replaceFirst("^0x", "") : dv, dv.contains("x") ? 16 : 10) : 0L;
                    values.add(vl);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (type.equals(SystemProperty.ValueTypeEnum.REAL.getText())) {
                if (values == null) {
                    values = new ArrayList();
                }
                try {
                    double vl = st != null ? Double.parseDouble(st) : 0.0;
                    values.add(vl);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!type.equals(SystemProperty.ValueTypeEnum.STRING.getText())) continue;
            if (values == null) {
                values = new ArrayList();
            }
            values.add(st);
        }
        return values;
    }

    public static Object getValueTypedFromString(String valueStr, SystemProperty.ValueTypeEnum type) {
        if (type == SystemProperty.ValueTypeEnum.BOOLEAN) {
            return Boolean.parseBoolean(valueStr);
        }
        if (type == SystemProperty.ValueTypeEnum.INTEGER) {
            try {
                String dv;
                String string = dv = valueStr == null ? null : valueStr.replaceAll("\\.\\d+$", "");
                return dv != null ? Long.parseLong(dv.contains("x") ? dv.replaceFirst("^0x", "") : dv, dv.contains("x") ? 16 : 10) : 0L;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 0L;
            }
        }
        if (type == SystemProperty.ValueTypeEnum.REAL) {
            try {
                return valueStr != null ? Double.parseDouble(valueStr) : 0.0;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 0.0;
            }
        }
        return valueStr;
    }

    public static Object getListValueTypedFromString(String valueStr, SystemProperty.ValueTypeEnum type) {
        ArrayList<Long> retLst;
        String[] tokens = valueStr == null ? new String[]{} : valueStr.split(",");
        switch (type) {
            case INTEGER: {
                ArrayList<Long> tmpLLst = new ArrayList<Long>();
                for (String tk : tokens) {
                    Long tokenObjVal = (Long)ConfigurationManager.getValueTypedFromString(tk = tk.trim(), type);
                    if (tokenObjVal == null) continue;
                    tmpLLst.add(tokenObjVal);
                }
                retLst = tmpLLst;
                break;
            }
            case REAL: {
                ArrayList<Double> tmpRLst = new ArrayList<Double>();
                for (String tk : tokens) {
                    Double tokenObjVal = (Double)ConfigurationManager.getValueTypedFromString(tk = tk.trim(), type);
                    if (tokenObjVal == null) continue;
                    tmpRLst.add(tokenObjVal);
                }
                retLst = tmpRLst;
                break;
            }
            case STRING: {
                ArrayList<String> tmpSLst = new ArrayList<String>();
                for (String tk : tokens) {
                    String tokenObjVal = (String)ConfigurationManager.getValueTypedFromString(tk = tk.trim(), type);
                    if (tokenObjVal == null) continue;
                    tmpSLst.add(tokenObjVal);
                }
                retLst = tmpSLst;
                break;
            }
            default: {
                return null;
            }
        }
        return retLst;
    }

    public ArrayList<SystemProperty> getPropertiesByEntity(String system, String entity, SystemProperty.Visibility vis, SystemProperty.Scope scope) {
        return this.getPropertiesByEntityWorker(system, entity, vis, scope, false);
    }

    private ArrayList<SystemProperty> getPropertiesByEntityWorker(String system, String entity, SystemProperty.Visibility vis, SystemProperty.Scope scope, boolean giveUpSearchOnFirstFound) {
        ArrayList<SystemProperty> list = new ArrayList<SystemProperty>();
        HashMap<String, SystemProperty> sy = this.map.get(system);
        if (sy != null) {
            for (SystemProperty p : sy.values()) {
                if (entity != null && !p.getCategory().equals(entity) || p.getVisibility().ordinal() < vis.ordinal() || p.getScope() != scope && scope != SystemProperty.Scope.GLOBAL) continue;
                list.add(p);
                if (!giveUpSearchOnFirstFound) continue;
                break;
            }
        }
        return list;
    }

    public ArrayList<SystemProperty> getClonedProperties(String system, SystemProperty.Visibility vis, SystemProperty.Scope scope) {
        ArrayList<SystemProperty> props = this.getPropertiesByEntity(system, null, vis, scope);
        HashMap<String, CustomSystemPropertyEditor> customEditors = new HashMap<String, CustomSystemPropertyEditor>();
        ArrayList<SystemProperty> clones = new ArrayList<SystemProperty>();
        for (SystemProperty p : props) {
            SystemProperty kv;
            CustomSystemPropertyEditor ce;
            SystemProperty sp = new SystemProperty();
            sp.setCategory(p.getCategory());
            sp.setCategoryId(p.getCategoryId());
            sp.setDefaultValue(p.getDefaultValue());
            sp.setDisplayName(p.getDisplayName());
            sp.setEditable(p.isEditable());
            sp.setEditor(p.getEditor());
            sp.setName(p.getName());
            sp.setRenderer(p.getRenderer());
            if (sp.getRenderer() != null && sp.getRenderer() instanceof SystemPropertyRenderer) {
                try {
                    SystemPropertyRenderer clone = ((SystemPropertyRenderer)sp.getRenderer()).clone();
                    sp.setRenderer(clone);
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
            }
            sp.setScope(p.getScope());
            sp.setShortDescription(p.getShortDescription());
            sp.setValue(p.getValue());
            sp.setType(p.getType());
            sp.setValueType(p.getValueType());
            sp.setVisibility(p.getVisibility());
            try {
                ce = (CustomSystemPropertyEditor)customEditors.get(p.getCategoryId());
                if (ce == null) {
                    ce = p.getSectionCustomEditor() != null ? p.getSectionCustomEditor().clone() : p.getSectionCustomEditor();
                    customEditors.put(p.getCategoryId(), ce);
                }
                sp.setSectionCustomEditor(ce);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            if (sp.getSectionCustomEditor() != null && (kv = (ce = sp.getSectionCustomEditor()).getSystemPropertiesList().get(p.getName())) != null) {
                ce.getSystemPropertiesList().put(sp.getName(), sp);
            }
            clones.add(sp);
        }
        return clones;
    }

    public ArrayList<SystemProperty> getProperties(String system, SystemProperty.Visibility vis, SystemProperty.Scope scope) {
        return this.getPropertiesByEntity(system, null, vis, scope);
    }

    public boolean hasProperties(String system, SystemProperty.Visibility vis, SystemProperty.Scope scope) {
        return this.getPropertiesByEntityWorker(system, null, vis, scope, true).size() > 0;
    }

    public static String convertArrayListToStringToPropValueString(String str) {
        return str.replaceAll("^\\[", "").replaceAll("\\]$", "");
    }

    public static void main(String[] args) {
        ConfigurationManager confMan = new ConfigurationManager();
        confMan.loadConfigurations();
        NeptusLog.pub().info((Object)("<###> " + confMan.getPropertiesByEntity("lauv-dolphin-1", "Sidescan", SystemProperty.Visibility.USER, SystemProperty.Scope.MANEUVER)));
        NeptusLog.pub().info((Object)("<###> " + confMan.getProperties("lauv-dolphin-1", SystemProperty.Visibility.USER, SystemProperty.Scope.MANEUVER)));
        NeptusLog.pub().info((Object)("<###> " + confMan.getProperties("lauv-dolphin-1", SystemProperty.Visibility.USER, SystemProperty.Scope.PLAN)));
        NeptusLog.pub().info((Object)("<###> " + confMan.getProperties("lauv-dolphin-1", SystemProperty.Visibility.DEVELOPER, SystemProperty.Scope.GLOBAL)));
    }
}

