/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.params;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import pt.lsts.imc.EntityParameter;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.SetEntityParameters;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.editor.renderer.I18nCellRenderer;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.params.ConfigurationManager;
import pt.lsts.neptus.params.SystemProperty;
import pt.lsts.neptus.params.renderer.I18nSystemPropertyRenderer;

public class ManeuverPayloadConfig
implements PropertiesProvider,
PropertyChangeListener {
    protected String vehicle;
    protected Maneuver maneuver;
    protected PropertySheetPanel psp;
    protected ArrayList<SystemProperty> props = null;
    protected final LinkedHashMap<String, SystemProperty> params = new LinkedHashMap();

    public ManeuverPayloadConfig(String vehicle, Maneuver maneuver, PropertySheetPanel psp) {
        this.maneuver = maneuver;
        this.vehicle = vehicle;
        this.psp = psp;
    }

    protected void updateFromActions(Maneuver man) {
        for (IMCMessage m : man.getStartActions().getAllMessages()) {
            if (m.getMgid() != 804) continue;
            try {
                this.setParameters(SetEntityParameters.clone((IMCMessage)m));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void setParameters(SetEntityParameters param) {
        String section = param.getName();
        for (EntityParameter ep : param.getParams()) {
            SystemProperty p = this.params.get(section + "." + ep.getName());
            if (p == null) {
                NeptusLog.pub().warn((Object)("Property not in config: " + section + "." + ep.getName()));
                continue;
            }
            boolean isList = false;
            if (ArrayList.class.equals((Object)p.getType())) {
                isList = true;
            }
            Object value = !isList ? ConfigurationManager.getValueTypedFromString(ep.getValue(), p.getValueType()) : ConfigurationManager.getListValueTypedFromString(ep.getValue(), p.getValueType());
            p.setValue(value);
            p.setTimeSync(System.currentTimeMillis());
        }
    }

    @Override
    public DefaultProperty[] getProperties() {
        if (this.props == null) {
            this.props = ConfigurationManager.getInstance().getClonedProperties(this.vehicle, SystemProperty.Visibility.USER, SystemProperty.Scope.MANEUVER);
            for (SystemProperty sp : this.props) {
                sp.resetToDefault();
                String name = sp.getName();
                this.params.put(sp.getCategoryId() + "." + name, sp);
                sp.addPropertyChangeListener(this);
                if (this.psp == null) continue;
                if (sp.getEditor() != null) {
                    this.psp.getEditorRegistry().registerEditor((Property)sp, (PropertyEditor)sp.getEditor());
                }
                if (sp.getRenderer() == null || !(sp.getRenderer() instanceof I18nSystemPropertyRenderer)) continue;
                I18nSystemPropertyRenderer rendSProp = (I18nSystemPropertyRenderer)sp.getRenderer();
                I18nCellRenderer newRend = new I18nCellRenderer(rendSProp.getUnitsStr());
                newRend.setI18nMapper(rendSProp.getI18nMapper());
                I18nCellRenderer rend = newRend;
                this.psp.getRendererRegistry().registerRenderer((Property)sp, (TableCellRenderer)((Object)rend));
            }
            this.updateFromActions(this.maneuver);
            for (SystemProperty spCh : this.params.values()) {
                for (SystemProperty sp : this.params.values()) {
                    PropertyChangeEvent evt = new PropertyChangeEvent(spCh, spCh.getName(), null, spCh.getValue());
                    sp.propertyChange(evt);
                }
            }
            this.setProperties((Property[])this.props.toArray(new DefaultProperty[0]));
        }
        return this.props.toArray(new DefaultProperty[0]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SystemProperty) {
            SystemProperty sp = (SystemProperty)evt.getSource();
            sp.setValue(evt.getNewValue());
            for (SystemProperty sprop : this.params.values()) {
                sprop.propertyChange(evt);
            }
            sp.propertyChange(evt);
        }
        if (this.psp != null) {
            this.psp.repaint();
        }
    }

    @Override
    public void setProperties(Property[] properties) {
        LinkedHashMap<String, ArrayList<EntityParameter>> mapCategoryParameterList = new LinkedHashMap<String, ArrayList<EntityParameter>>();
        for (Property p : properties) {
            String category;
            if (!(p instanceof SystemProperty)) continue;
            SystemProperty sp = (SystemProperty)p;
            if (p.getValue() == null || (category = sp.getCategoryId()) == null) continue;
            EntityParameter ep = new EntityParameter();
            ep.setName(sp.getName());
            boolean isList = false;
            if (ArrayList.class.equals((Object)sp.getType())) {
                isList = true;
            }
            String str = sp.getValue().toString();
            if (isList) {
                str = ConfigurationManager.convertArrayListToStringToPropValueString(str);
            }
            ep.setValue(str);
            ArrayList<EntityParameter> entParamList = (ArrayList<EntityParameter>)mapCategoryParameterList.get(category);
            if (entParamList == null) {
                entParamList = new ArrayList<EntityParameter>();
                mapCategoryParameterList.put(category, entParamList);
            }
            entParamList.add(ep);
        }
        Vector<IMCMessage> ps = new Vector<IMCMessage>();
        for (String entity : mapCategoryParameterList.keySet()) {
            SetEntityParameters tmp = new SetEntityParameters();
            tmp.setName(entity);
            tmp.setParams((Collection)mapCategoryParameterList.get(entity));
            ps.add((IMCMessage)tmp);
        }
        this.maneuver.getStartActions().parseMessages(ps);
    }

    @Override
    public String getPropertiesDialogTitle() {
        return null;
    }

    @Override
    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }
}

