/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.params;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.params.SystemConfigurationEditorPanel;
import pt.lsts.neptus.params.SystemProperty;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;

@PluginDescription(name="System Configuration", icon="images/settings2.png")
@Popup(accelerator=90, pos=Popup.POSITION.CENTER, width=600, height=600)
public class SystemConfiguration
extends ConsolePanel
implements NeptusMessageListener,
MainVehicleChangeListener {
    private SystemConfigurationEditorPanel systemConfEditor;

    public SystemConfiguration(ConsoleLayout console) {
        super(console);
    }

    @Override
    public void initSubPanel() {
        this.initialize();
    }

    private void initialize() {
        this.removeAll();
        this.systemConfEditor = new SystemConfigurationEditorPanel(this.getMainVehicleId(), SystemProperty.Scope.GLOBAL, SystemProperty.Visibility.USER, true, false, true, this.getConsole().getImcMsgManager());
        this.setLayout(new BorderLayout());
        this.add(this.systemConfEditor);
        this.revalidate();
        this.repaint();
    }

    @Subscribe
    public void mainVehicleChangeNotification(ConsoleEventMainSystemChange ev) {
        this.systemConfEditor.setSystemId(ev.getCurrent());
    }

    @Override
    public void cleanSubPanel() {
    }

    @Override
    public String[] getObservedMessages() {
        return new String[]{"EntityParameters"};
    }

    @Override
    public void messageArrived(IMCMessage message) {
        SystemConfigurationEditorPanel.updatePropertyWithMessageArrived(this.systemConfEditor, message);
    }
}

