/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.params;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorFactory;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererFactory;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import pt.lsts.imc.EntityParameter;
import pt.lsts.imc.EntityParameters;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.QueryEntityParameters;
import pt.lsts.imc.SaveEntityParameters;
import pt.lsts.imc.SetEntityParameters;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.comm.manager.imc.MessageDeliveryListener;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.params.ConfigurationManager;
import pt.lsts.neptus.params.SystemProperty;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.GeneralPreferences;

public class SystemConfigurationEditorPanel
extends JPanel
implements PropertyChangeListener {
    protected final LinkedHashMap<String, SystemProperty> params = new LinkedHashMap();
    protected PropertySheetPanel psp;
    private JButton sendButton;
    private JButton saveButton;
    private JButton refreshButton;
    private JButton resetButton;
    private JLabel titleLabel;
    private JCheckBox checkAdvance;
    private JComboBox<SystemProperty.Scope> scopeComboBox;
    protected boolean refreshing = false;
    private PropertyEditorRegistry per;
    private PropertyRendererRegistry prr;
    private SystemProperty.Scope scopeToUse = SystemProperty.Scope.GLOBAL;
    private SystemProperty.Visibility visibility = SystemProperty.Visibility.USER;
    protected String systemId;
    protected ImcSystem sid = null;
    protected ImcMsgManager imcMsgManager;

    public SystemConfigurationEditorPanel(String systemId, SystemProperty.Scope scopeToUse, SystemProperty.Visibility visibility, boolean showSendButton, boolean showScopeCombo, boolean showResetButton, ImcMsgManager imcMsgManager) {
        this.systemId = systemId;
        this.imcMsgManager = imcMsgManager;
        this.scopeToUse = scopeToUse;
        this.visibility = visibility;
        this.initialize(showSendButton, showScopeCombo, showResetButton);
    }

    private void initialize(boolean showSendButton, boolean showScopeCombo, boolean showResetButton) {
        this.setLayout((LayoutManager)new MigLayout());
        this.scopeComboBox = new JComboBox<SystemProperty.Scope>(SystemProperty.Scope.values()){

            @Override
            public void setSelectedItem(Object anObject) {
                super.setSelectedItem(anObject);
            }
        };
        this.scopeComboBox.setRenderer(new ListCellRenderer<SystemProperty.Scope>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends SystemProperty.Scope> list, SystemProperty.Scope value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = new JLabel(I18n.text(value.getText()));
                label.setOpaque(true);
                if (isSelected) {
                    label.setBackground(list.getSelectionBackground());
                    label.setForeground(list.getSelectionForeground());
                } else {
                    label.setBackground(list.getBackground());
                    label.setForeground(list.getForeground());
                }
                return label;
            }
        });
        this.scopeComboBox.setSelectedItem((Object)this.scopeToUse);
        this.scopeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SystemConfigurationEditorPanel.this.scopeToUse = (SystemProperty.Scope)((Object)e.getItem());
                new Thread(){

                    @Override
                    public void run() {
                        if (SystemConfigurationEditorPanel.this.refreshButton != null) {
                            SystemConfigurationEditorPanel.this.refreshButton.doClick(50);
                        }
                    }
                }.start();
            }
        });
        this.titleLabel = new JLabel("<html><b>" + this.createTitle() + "</b></html>");
        this.add((Component)this.titleLabel, "w 100%, wrap");
        this.psp = new PropertySheetPanel();
        this.psp.setSortingCategories(true);
        this.psp.setSortingProperties(false);
        this.psp.setDescriptionVisible(true);
        this.psp.setMode(1);
        this.psp.setToolBarVisible(false);
        this.resetPropertiesEditorAndRendererFactories();
        this.add((Component)this.psp, "w 100%, h 100%, wrap");
        this.sendButton = new JButton(new AbstractAction(I18n.text("Send")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemConfigurationEditorPanel.this.sendPropertiesToSystem();
            }
        });
        this.sendButton.setToolTipText(I18n.text("Send the modified properties."));
        if (showSendButton) {
            this.add((Component)this.sendButton, "sg buttons, split");
        }
        this.refreshButton = new JButton(new AbstractAction(I18n.text("Refresh")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemConfigurationEditorPanel.this.refreshPropertiesOnPanel();
            }
        });
        this.refreshButton.setToolTipText(I18n.text("Requests the entities sections parameters from the vehicle."));
        this.add((Component)this.refreshButton, "sg buttons, split");
        this.saveButton = new JButton(new AbstractAction(I18n.text("Save")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemConfigurationEditorPanel.this.savePropertiesToSystem();
            }
        });
        this.saveButton.setToolTipText(I18n.text("Saves the visible entities sections in the vehicle."));
        if (showSendButton) {
            this.add((Component)this.saveButton, "sg buttons, split");
        }
        this.resetButton = new JButton(new AbstractAction(I18n.text("Reset")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemConfigurationEditorPanel.this.resetPropertiesOnPanel();
            }
        });
        this.resetButton.setToolTipText(I18n.text("Local reset. Needs to be sent to system."));
        if (showResetButton) {
            this.add((Component)this.resetButton, "sg buttons, gapbefore 30, split, wrap");
        }
        if (showScopeCombo) {
            this.add(this.scopeComboBox, "split, w :160:");
        }
        this.checkAdvance = new JCheckBox(I18n.text("Access Developer Parameters"));
        this.checkAdvance.setToolTipText("<html>" + I18n.textc("Be careful changing these values.<br>They may make the vehicle inoperable.", "This will be a tooltip, and use <br> to change line."));
        this.add(this.checkAdvance);
        if (this.visibility == SystemProperty.Visibility.DEVELOPER) {
            this.checkAdvance.setSelected(true);
        } else {
            this.checkAdvance.setSelected(false);
        }
        this.checkAdvance.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (SystemConfigurationEditorPanel.this.checkAdvance.isSelected()) {
                    SystemConfigurationEditorPanel.this.visibility = SystemProperty.Visibility.DEVELOPER;
                } else {
                    SystemConfigurationEditorPanel.this.visibility = SystemProperty.Visibility.USER;
                }
                SystemConfigurationEditorPanel.this.refreshPropertiesOnPanel();
            }
        });
        this.checkAdvance.setFocusable(false);
        this.refreshPropertiesOnPanel();
        this.revalidate();
        this.repaint();
    }

    private void resetPropertiesEditorAndRendererFactories() {
        this.per = new PropertyEditorRegistry();
        this.psp.setEditorFactory((PropertyEditorFactory)this.per);
        this.prr = new PropertyRendererRegistry();
        this.psp.setRendererFactory((PropertyRendererFactory)this.prr);
    }

    public LinkedHashMap<String, SystemProperty> getParams() {
        return this.params;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.sid = ImcSystemsHolder.getSystemWithName(this.systemId);
        this.refreshPropertiesOnPanel();
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
    }

    private synchronized void refreshPropertiesOnPanel() {
        this.titleLabel.setText("<html><b>" + this.createTitle() + "</b></html>");
        this.removeAllPropertiesFromPanel();
        this.resetPropertiesEditorAndRendererFactories();
        ArrayList<SystemProperty> pr = ConfigurationManager.getInstance().getProperties(this.systemId, this.visibility, this.scopeToUse);
        ArrayList<String> secNames = new ArrayList<String>();
        for (SystemProperty sp : pr) {
            String sectionName = sp.getCategoryId();
            String name = sp.getName();
            if (!secNames.contains(sectionName)) {
                secNames.add(sectionName);
            }
            this.params.put(sectionName + "." + name, sp);
            sp.addPropertyChangeListener(this);
            this.psp.addProperty((Property)sp);
            if (sp.getEditor() != null) {
                this.per.registerEditor((Property)sp, (PropertyEditor)sp.getEditor());
            }
            if (sp.getRenderer() == null) continue;
            this.prr.registerRenderer((Property)sp, (TableCellRenderer)sp.getRenderer());
        }
        for (SystemProperty spCh : this.params.values()) {
            for (SystemProperty sp : this.params.values()) {
                PropertyChangeEvent evt = new PropertyChangeEvent(spCh, spCh.getName(), null, spCh.getValue());
                sp.propertyChange(evt);
            }
        }
        for (String sectionName : secNames) {
            this.queryValues(sectionName, this.scopeToUse.getText(), this.visibility.getText());
        }
        this.revalidate();
        this.repaint();
    }

    private synchronized void resetPropertiesOnPanel() {
        for (SystemProperty sp : this.params.values()) {
            sp.resetToDefault();
        }
        this.psp.repaint();
    }

    private void removeAllPropertiesFromPanel() {
        this.params.clear();
        for (Property p : this.psp.getProperties()) {
            this.psp.removeProperty(p);
        }
    }

    private String createTitle() {
        return I18n.textf("%systemName Parameters", this.getSystemId() == null ? "" : this.getSystemId());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.refreshing && evt.getSource() instanceof SystemProperty) {
            SystemProperty sp = (SystemProperty)evt.getSource();
            sp.setValue(evt.getNewValue());
            for (SystemProperty sprop : this.params.values()) {
                sprop.propertyChange(evt);
            }
            sp.propertyChange(evt);
        }
    }

    private void queryValues(String entityName, String scope, String visibility) {
        QueryEntityParameters qep = new QueryEntityParameters();
        qep.setScope(scope);
        qep.setVisibility(visibility);
        qep.setName(entityName);
        this.send((IMCMessage)qep);
    }

    private void saveRequest(String entityName) {
        SaveEntityParameters qep = new SaveEntityParameters();
        qep.setName(entityName);
        this.send((IMCMessage)qep);
    }

    private void sendProperty(SystemProperty ... propsList) {
        LinkedHashMap<String, ArrayList<EntityParameter>> mapCategoryParameterList = new LinkedHashMap<String, ArrayList<EntityParameter>>();
        for (SystemProperty prop : propsList) {
            String category;
            if (prop.getValue() == null || (category = prop.getCategoryId()) == null) continue;
            EntityParameter ep = new EntityParameter();
            ep.setName(prop.getName());
            boolean isList = false;
            if (ArrayList.class.equals((Object)prop.getType())) {
                isList = true;
            }
            String str = prop.getValue().toString();
            if (isList) {
                str = ConfigurationManager.convertArrayListToStringToPropValueString(str);
            }
            ep.setValue(str);
            ArrayList<EntityParameter> entParamList = (ArrayList<EntityParameter>)mapCategoryParameterList.get(category);
            if (entParamList == null) {
                entParamList = new ArrayList<EntityParameter>();
                mapCategoryParameterList.put(category, entParamList);
            }
            entParamList.add(ep);
        }
        ArrayList<SetEntityParameters> msgs = new ArrayList<SetEntityParameters>(mapCategoryParameterList.size());
        for (String cat : mapCategoryParameterList.keySet()) {
            ArrayList propList = (ArrayList)mapCategoryParameterList.get(cat);
            SetEntityParameters setParams = new SetEntityParameters();
            setParams.setName(cat);
            setParams.setParams((Collection)propList);
            msgs.add(setParams);
        }
        for (SetEntityParameters setEntityParameters : msgs) {
            this.send((IMCMessage)setEntityParameters);
        }
    }

    private void sendPropertiesToSystem() {
        LinkedHashSet<SystemProperty> sentProps = new LinkedHashSet<SystemProperty>();
        ArrayList<SystemProperty> sysPropToSend = new ArrayList<SystemProperty>();
        for (SystemProperty sp : this.params.values()) {
            if (sp.getTimeDirty() <= sp.getTimeSync()) continue;
            sysPropToSend.add(sp);
            sentProps.add(sp);
        }
        if (sysPropToSend.size() > 0) {
            this.sendProperty(sysPropToSend.toArray(new SystemProperty[sysPropToSend.size()]));
            ArrayList<String> secNames = new ArrayList<String>();
            for (SystemProperty sp : sentProps) {
                String sectionName = sp.getCategoryId();
                if (secNames.contains(sectionName)) continue;
                secNames.add(sectionName);
            }
            for (String sec : secNames) {
                this.queryValues(sec, this.scopeToUse.getText(), this.visibility.getText());
            }
        }
    }

    private void savePropertiesToSystem() {
        Collection<SystemProperty> propsInPanel = this.params.values();
        if (propsInPanel.size() > 0) {
            ArrayList<String> secNames = new ArrayList<String>();
            for (SystemProperty sp : propsInPanel) {
                String sectionName = sp.getCategoryId();
                if (secNames.contains(sectionName)) continue;
                secNames.add(sectionName);
            }
            for (String sec : secNames) {
                this.queryValues(sec, this.scopeToUse.getText(), this.visibility.getText());
            }
            for (String sec : secNames) {
                this.saveRequest(sec);
            }
        }
    }

    private void send(IMCMessage msg) {
        MessageDeliveryListener mdl = new MessageDeliveryListener(){

            @Override
            public void deliveryUnreacheable(IMCMessage message) {
            }

            @Override
            public void deliveryUncertain(IMCMessage message, Object msg) {
            }

            @Override
            public void deliveryTimeOut(IMCMessage message) {
            }

            @Override
            public void deliverySuccess(IMCMessage message) {
            }

            @Override
            public void deliveryError(IMCMessage message, Object error) {
            }
        };
        if (this.sid == null) {
            this.sid = ImcSystemsHolder.getSystemWithName(this.getSystemId());
        }
        if (this.sid != null) {
            this.imcMsgManager.sendReliablyNonBlocking(msg, this.sid.getId(), mdl);
        } else {
            this.imcMsgManager.sendMessageToSystem(msg, this.getSystemId());
        }
    }

    public static void updatePropertyWithMessageArrived(SystemConfigurationEditorPanel systemConfEditor, IMCMessage message) {
        if (systemConfEditor == null || message == null || !(message instanceof EntityParameters)) {
            return;
        }
        try {
            systemConfEditor.setRefreshing(true);
            EntityParameters eps = EntityParameters.clone((IMCMessage)message);
            String section = eps.getName();
            for (EntityParameter ep : eps.getParams()) {
                SystemProperty p = systemConfEditor.getParams().get(section + "." + ep.getName());
                if (p == null) {
                    NeptusLog.pub().warn((Object)("Property not in config: " + section + " - " + ep.getName() + " from system with ID " + message.getSrc()));
                    continue;
                }
                boolean isList = false;
                if (ArrayList.class.equals((Object)p.getType())) {
                    isList = true;
                }
                Object value = !isList ? ConfigurationManager.getValueTypedFromString(ep.getValue(), p.getValueType()) : ConfigurationManager.getListValueTypedFromString(ep.getValue(), p.getValueType());
                p.setValue(value);
                p.setTimeSync(System.currentTimeMillis());
            }
            systemConfEditor.revalidate();
            systemConfEditor.repaint();
            systemConfEditor.setRefreshing(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String vehicle = "lauv-dolphin-1";
        GeneralPreferences.language = "pt_PT";
        SystemConfigurationEditorPanel sc1 = new SystemConfigurationEditorPanel(vehicle, SystemProperty.Scope.MANEUVER, SystemProperty.Visibility.USER, true, true, true, ImcMsgManager.getManager());
        SystemConfigurationEditorPanel sc2 = new SystemConfigurationEditorPanel(vehicle, SystemProperty.Scope.MANEUVER, SystemProperty.Visibility.USER, true, true, true, ImcMsgManager.getManager());
        GuiUtils.testFrame(sc1);
        GuiUtils.testFrame(sc2);
    }
}

